/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.FaultToleranceService;
import fish.payara.microprofile.faulttolerance.FaultToleranceServiceConfiguration;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.BindableFaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceMethodContextImpl;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceRequestTracing;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceUtils;
import fish.payara.microprofile.faulttolerance.service.MethodFaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.service.MethodKey;
import fish.payara.microprofile.faulttolerance.service.Stereotypes;
import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.context.control.RequestContextController;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@ContractsProvided(value={FaultToleranceService.class})
@Service(name="microprofile-fault-tolerance-service")
@RunLevel(value=10)
public class FaultToleranceServiceImpl
implements EventListener,
FaultToleranceService,
MonitoringDataSource,
FaultToleranceRequestTracing {
    private static final Logger logger = Logger.getLogger(FaultToleranceServiceImpl.class.getName());
    private InvocationManager invocationManager;
    private FaultToleranceServiceConfiguration config;
    @Inject
    private RequestTracingService requestTracingService;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Events events;
    @Inject
    private MetricsService metricsService;
    private final ConcurrentMap<MethodKey, FaultToleranceMethodContextImpl> contextByMethod = new ConcurrentHashMap<MethodKey, FaultToleranceMethodContextImpl>();
    private final ConcurrentMap<String, BindableFaultToleranceConfig> configByAppName = new ConcurrentHashMap<String, BindableFaultToleranceConfig>();
    private ExecutorService asyncExecutorService;
    private ScheduledExecutorService delayExecutorService;

    @PostConstruct
    public void postConstruct() throws NamingException {
        this.events.register((EventListener)this);
        this.invocationManager = (InvocationManager)this.serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.requestTracingService = (RequestTracingService)this.serviceLocator.getService(RequestTracingService.class, new Annotation[0]);
        this.config = (FaultToleranceServiceConfiguration)this.serviceLocator.getService(FaultToleranceServiceConfiguration.class, new Annotation[0]);
        InitialContext context = new InitialContext();
        this.asyncExecutorService = (ManagedExecutorService)context.lookup(this.config.getManagedExecutorService());
        this.delayExecutorService = (ManagedScheduledExecutorService)context.lookup(this.config.getManagedScheduledExecutorService());
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)event.hook();
            this.deregisterApplication(info);
            FaultTolerancePolicy.clean(info.getAppClassLoader());
        }
    }

    @MonitoringData(ns="ft")
    public void collect(MonitoringDataCollector collector) {
        for (Map.Entry methodEntry : this.contextByMethod.entrySet()) {
            MonitoringDataCollector methodCollector = collector.group((CharSequence)((MethodKey)methodEntry.getKey()).getMethodId()).tag((CharSequence)"app", (CharSequence)((FaultToleranceMethodContextImpl)methodEntry.getValue()).getAppName());
            FaultToleranceMethodContext context = (FaultToleranceMethodContext)methodEntry.getValue();
            BlockingQueue<Thread> concurrentExecutions = context.getConcurrentExecutions();
            if (concurrentExecutions != null) {
                FaultToleranceServiceImpl.collectBulkheadSemaphores(methodCollector, concurrentExecutions);
                FaultToleranceServiceImpl.collectBulkheadSemaphores(methodCollector, concurrentExecutions, context.getQueuingOrRunningPopulation());
            }
            FaultToleranceServiceImpl.collectCircuitBreakerState(methodCollector, context.getState());
        }
    }

    private static void collectBulkheadSemaphores(MonitoringDataCollector collector, BlockingQueue<Thread> concurrentExecutions) {
        collector.collect((CharSequence)"RemainingConcurrentExecutionsCapacity", (long)concurrentExecutions.remainingCapacity()).collect((CharSequence)"ConcurrentExecutions", (long)concurrentExecutions.size());
    }

    private static void collectBulkheadSemaphores(MonitoringDataCollector collector, BlockingQueue<Thread> concurrentExecutions, AtomicInteger queuingOrRunningPopulation) {
        collector.collect((CharSequence)"WaitingQueuePopulation", (long)(queuingOrRunningPopulation.get() - concurrentExecutions.size()));
    }

    private static void collectCircuitBreakerState(MonitoringDataCollector collector, CircuitBreakerState state) {
        if (state == null) {
            return;
        }
        collector.collect((CharSequence)"circuitBreakerHalfOpenSuccessful", (long)state.getHalfOpenSuccessfulResultCounter()).collect((CharSequence)"circuitBreakerState", state.getCircuitState().name().charAt(0));
    }

    @Override
    public FaultToleranceConfig getConfig(InvocationContext context, Stereotypes stereotypes) {
        return this.configByAppName.computeIfAbsent(this.getAppName(context), key -> new BindableFaultToleranceConfig(stereotypes)).bindTo(context);
    }

    private MetricsService.MetricsContext getMetricsContext() {
        try {
            return this.metricsService.getContext(true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void deregisterApplication(ApplicationInfo appInfo) {
        this.configByAppName.remove(appInfo.getName());
        this.contextByMethod.keySet().removeIf(methodKey -> methodKey.targetClass.getClassLoader().equals(appInfo.getAppClassLoader()));
    }

    private String getAppName(InvocationContext context) {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        String appName = currentInvocation.getAppName();
        return appName != null ? appName : "common";
    }

    @Override
    public void startSpan(RequestTraceSpan span, InvocationContext context) {
        if (this.requestTracingService != null && this.requestTracingService.isRequestTracingEnabled()) {
            this.addGenericFaultToleranceRequestTracingDetails(span, context);
            this.requestTracingService.startTrace(span);
        }
    }

    @Override
    public void endSpan() {
        if (this.requestTracingService != null && this.requestTracingService.isRequestTracingEnabled()) {
            this.requestTracingService.endTrace();
        }
    }

    private void addGenericFaultToleranceRequestTracingDetails(RequestTraceSpan span, InvocationContext context) {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        span.addSpanTag("App Name", currentInvocation.getAppName());
        span.addSpanTag("Component ID", currentInvocation.getComponentId());
        span.addSpanTag("Module Name", currentInvocation.getModuleName());
        span.addSpanTag("Class Name", context.getMethod().getDeclaringClass().getName());
        span.addSpanTag("Method Name", context.getMethod().getName());
    }

    @Override
    public FaultToleranceMethodContext getMethodContext(InvocationContext context, FaultTolerancePolicy policy, RequestContextController requestContextController) {
        return this.contextByMethod.computeIfAbsent(new MethodKey(context), methodKey -> this.createMethodContext((MethodKey)methodKey, context, requestContextController)).boundTo(context, policy);
    }

    private FaultToleranceMethodContextImpl createMethodContext(MethodKey methodKey, InvocationContext context, RequestContextController requestContextController) {
        MetricsService.MetricsContext metricsContext = this.getMetricsContext();
        MetricRegistry metricRegistry = metricsContext != null ? metricsContext.getBaseRegistry() : null;
        String appName = metricsContext != null ? metricsContext.getName() : "";
        FaultToleranceMetrics metrics = metricRegistry == null ? FaultToleranceMetrics.DISABLED : new MethodFaultToleranceMetrics(metricRegistry, FaultToleranceUtils.getCanonicalMethodName(context));
        logger.log(Level.FINE, "Creating FT method context for {0}", methodKey);
        return new FaultToleranceMethodContextImpl(requestContextController, this, metrics, this.asyncExecutorService, this.delayExecutorService, appName);
    }
}

