/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import java.util.logging.Level;
import org.glassfish.webservices.monitoring.EndpointImpl;
import org.glassfish.webservices.monitoring.EndpointType;
import org.glassfish.webservices.monitoring.HttpRequestInfoImpl;
import org.glassfish.webservices.monitoring.MessageListener;
import org.glassfish.webservices.monitoring.MessageTraceImpl;
import org.glassfish.webservices.monitoring.ThreadLocalInfo;
import org.glassfish.webservices.monitoring.TransportInfo;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class JAXRPCEndpointImpl
extends EndpointImpl
implements SystemHandlerDelegate {
    SystemHandlerDelegate parent = null;

    JAXRPCEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }

    public boolean processRequest(SOAPMessageContext messageContext) {
        boolean status = true;
        if (this.parent != null) {
            status = this.parent.processRequest(messageContext);
        }
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (!this.listeners.isEmpty() || wsEngine.hasGlobalMessageListener()) {
                ThreadLocalInfo config = wsEngine.getThreadLocal().get();
                if (config != null && config.getMessageId() != null) {
                    HttpRequestInfoImpl info = new HttpRequestInfoImpl(config.getRequest());
                    wsEngine.processRequest(config.getMessageId(), messageContext, (TransportInfo)info);
                }
                if (!this.listeners.isEmpty()) {
                    if (config == null) {
                        config = new ThreadLocalInfo(null, null);
                    }
                    MessageTraceImpl request = new MessageTraceImpl();
                    request.setEndpoint(this);
                    request.setMessageContext(messageContext);
                    if (config.getRequest() != null) {
                        request.setTransportInfo(new HttpRequestInfoImpl(config.getRequest()));
                    }
                    config.setRequestMessageTrace(request);
                }
            }
        }
        catch (Throwable t) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "AS-WSJSR109IMPL-00043", t.getMessage());
            RuntimeException re = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            throw re;
        }
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) {
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            ThreadLocalInfo config;
            if ((wsEngine.hasGlobalMessageListener() || !this.listeners.isEmpty()) && (config = wsEngine.getThreadLocal().get()) != null) {
                if (config.getMessageId() != null) {
                    wsEngine.processResponse(config.getMessageId(), messageContext);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl response = new MessageTraceImpl();
                    response.setEndpoint(this);
                    response.setMessageContext(messageContext);
                    for (MessageListener listener : this.listeners) {
                        listener.invocationProcessed(config.getRequestMessageTrace(), response);
                    }
                }
            }
            wsEngine.getThreadLocal().remove();
            if (this.parent != null) {
                this.parent.processResponse(messageContext);
            }
        }
        catch (Throwable t) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "AS-WSJSR109IMPL-00044", t.getMessage());
            RuntimeException re = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            throw re;
        }
    }

    public void setParent(SystemHandlerDelegate parent) {
        this.parent = parent;
    }
}

