/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.BasicTopic;
import com.sun.messaging.jmq.DestinationName;
import com.sun.messaging.naming.AdministeredObjectFactory;
import com.sun.messaging.naming.ReferenceGenerator;
import javax.jms.JMSException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class Topic
extends BasicTopic
implements Referenceable {
    public Topic() {
    }

    public Topic(String name) throws JMSException {
        super(name);
    }

    @Override
    public Reference getReference() {
        return ReferenceGenerator.getReference(this, AdministeredObjectFactory.class.getName());
    }

    public void setName(String name) {
        if (!DestinationName.isSyntaxValid(name)) {
            throw new IllegalArgumentException("MQ:Topic:Invalid Topic Name - " + name);
        }
        this.configuration.put("imqDestinationName", name);
    }

    public void setDescription(String description) {
        this.configuration.put("imqDestinationDescription", description);
    }

    public String getDescription() {
        try {
            return this.getProperty("imqDestinationDescription");
        }
        catch (JMSException jmse) {
            return "";
        }
    }
}

