/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import fish.payara.microprofile.openapi.impl.model.media.DiscriminatorImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import fish.payara.microprofile.openapi.impl.rest.app.provider.ObjectMapperFactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.EnumModel;
import org.glassfish.hk2.classmodel.reflect.Type;

@JsonIgnoreProperties(value={"name"}, allowSetters=true)
public class SchemaImpl
extends ExtensibleImpl<Schema>
implements Schema {
    private static final Logger LOGGER = Logger.getLogger(SchemaImpl.class.getName());
    private Object defaultValue;
    private String name;
    private String title;
    private BigDecimal multipleOf;
    private BigDecimal maximum;
    private Boolean exclusiveMaximum;
    private BigDecimal minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private List<String> required = ModelUtils.createList();
    private Schema.SchemaType type;
    private Map<String, Schema> properties = ModelUtils.createMap();
    private String description;
    private String format;
    private String ref;
    private Boolean nullable;
    private Boolean readOnly;
    private Boolean writeOnly;
    private Object example;
    private ExternalDocumentation externalDocs;
    private Boolean deprecated;
    private XML xml;
    private List<Object> enumeration = ModelUtils.createList();
    private Discriminator discriminator;
    private Schema not;
    private List<Schema> anyOf = ModelUtils.createList();
    private List<Schema> allOf = ModelUtils.createList();
    private List<Schema> oneOf = ModelUtils.createList();
    private Object additionalProperties;
    private Schema items;
    @JsonIgnore
    private String implementation;
    @JsonIgnore
    private boolean isRequired;

    public static SchemaImpl valueOf(String content) throws JsonMappingException, JsonProcessingException {
        return (SchemaImpl)ObjectMapperFactory.createJson().readValue(content, SchemaImpl.class);
    }

    public static SchemaImpl createInstance(AnnotationModel annotation, ApiContext context) {
        List oneOf;
        List allOf;
        List anyOf;
        Schema schema;
        String not;
        String maximum;
        String implementationClass;
        String ref;
        SchemaImpl from = new SchemaImpl();
        if (annotation == null) {
            return from;
        }
        Boolean isRequired = (Boolean)annotation.getValue("required", Boolean.class);
        if (isRequired != null) {
            from.isRequired = isRequired;
        }
        if ((ref = (String)annotation.getValue("ref", String.class)) != null && !ref.isEmpty()) {
            from.setRef(ref);
            return from;
        }
        EnumModel typeEnum = (EnumModel)annotation.getValue("type", EnumModel.class);
        if (typeEnum != null) {
            from.setType(Schema.SchemaType.valueOf((String)typeEnum.getValue()));
        }
        if ((implementationClass = (String)annotation.getValue("implementation", String.class)) != null) {
            SchemaImpl.setImplementation(from, implementationClass, true, context);
        }
        from.setDefaultValue(annotation.getValue("defaultValue", Object.class));
        from.setName((String)annotation.getValue("name", String.class));
        from.setTitle((String)annotation.getValue("title", String.class));
        Double multipleOf = (Double)annotation.getValue("multipleOf", Double.class);
        if (multipleOf != null) {
            from.setMultipleOf(BigDecimal.valueOf(multipleOf));
        }
        if ((maximum = (String)annotation.getValue("maximum", String.class)) != null && !maximum.isEmpty()) {
            from.setMaximum(new BigDecimal(maximum));
        }
        from.setExclusiveMaximum((Boolean)annotation.getValue("exclusiveMaximum", Boolean.class));
        String minimum = (String)annotation.getValue("minimum", String.class);
        if (minimum != null && !minimum.isEmpty()) {
            from.setMinimum(new BigDecimal(minimum));
        }
        from.setExclusiveMinimum((Boolean)annotation.getValue("exclusiveMinimum", Boolean.class));
        from.setMaxLength((Integer)annotation.getValue("maxLength", Integer.class));
        from.setMinLength((Integer)annotation.getValue("minLength", Integer.class));
        from.setPattern((String)annotation.getValue("pattern", String.class));
        from.setMaxItems((Integer)annotation.getValue("maxItems", Integer.class));
        from.setMinItems((Integer)annotation.getValue("minItems", Integer.class));
        from.setUniqueItems((Boolean)annotation.getValue("uniqueItems", Boolean.class));
        from.setMaxProperties((Integer)annotation.getValue("maxProperties", Integer.class));
        from.setMinProperties((Integer)annotation.getValue("minProperties", Integer.class));
        from.setRequired((List)annotation.getValue("requiredProperties", List.class));
        ModelUtils.extractAnnotations(annotation, context, "properties", "name", SchemaImpl::createInstance, from::addProperty);
        for (Map.Entry<String, Schema> property : from.getProperties().entrySet()) {
            SchemaImpl propertySchema = (SchemaImpl)property.getValue();
            if (!propertySchema.isRequired) continue;
            from.addRequired(property.getKey());
        }
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setFormat((String)annotation.getValue("format", String.class));
        from.setNullable((Boolean)annotation.getValue("nullable", Boolean.class));
        from.setReadOnly((Boolean)annotation.getValue("readOnly", Boolean.class));
        from.setWriteOnly((Boolean)annotation.getValue("writeOnly", Boolean.class));
        from.setExample(annotation.getValue("example", Object.class));
        AnnotationModel externalDocs = (AnnotationModel)annotation.getValue("externalDocs", AnnotationModel.class);
        if (externalDocs != null) {
            from.setExternalDocs(ExternalDocumentationImpl.createInstance(externalDocs));
        }
        from.setDeprecated((Boolean)annotation.getValue("deprecated", Boolean.class));
        from.setEnumeration((List)annotation.getValue("enumeration", List.class));
        String discriminatorProperty = (String)annotation.getValue("discriminatorProperty", String.class);
        List discriminatorMapping = (List)annotation.getValue("discriminatorMapping", List.class);
        if (discriminatorMapping != null && !discriminatorProperty.isEmpty()) {
            DiscriminatorImpl discriminator = new DiscriminatorImpl();
            discriminator.setPropertyName(discriminatorProperty);
            for (AnnotationModel mapping : discriminatorMapping) {
                String value = (String)mapping.getValue("value", String.class);
                String schema2 = (String)mapping.getValue("schema", String.class);
                discriminator.addMapping(value, ModelUtils.getSimpleName(schema2));
            }
            from.setDiscriminator(discriminator);
        }
        if ((not = (String)annotation.getValue("not", String.class)) != null && (schema = from.getSchemaInstance(not, context)) != null) {
            from.setNot(schema);
        }
        if ((anyOf = (List)annotation.getValue("anyOf", List.class)) != null) {
            ModelUtils.mergeImmutableList(from.getAnyOf(), from.getSchemaInstances(anyOf, context), from::setAnyOf);
        }
        if ((allOf = (List)annotation.getValue("allOf", List.class)) != null) {
            ModelUtils.mergeImmutableList(from.getAllOf(), from.getSchemaInstances(allOf, context), from::setAllOf);
        }
        if ((oneOf = (List)annotation.getValue("oneOf", List.class)) != null) {
            ModelUtils.mergeImmutableList(from.getOneOf(), from.getSchemaInstances(oneOf, context), from::setOneOf);
        }
        return from;
    }

    private List<Schema> getSchemaInstances(List<String> fromList, ApiContext context) {
        List<Schema> to = ModelUtils.createList();
        if (fromList != null) {
            for (String from : fromList) {
                Schema schema = this.getSchemaInstance(from, context);
                if (schema == null) continue;
                to.add(schema);
            }
        }
        return to;
    }

    private Schema getSchemaInstance(String schemaClassName, ApiContext context) {
        ClassModel schemaClassModel;
        Type schemaType;
        if (schemaClassName != null && !schemaClassName.equals("java.lang.Void") && (schemaType = context.getType(schemaClassName)) instanceof ClassModel && (schemaClassModel = (ClassModel)schemaType).isInstanceOf(Schema.class.getName())) {
            try {
                Class<?> oneOfClass = context.getApplicationClassLoader().loadClass(schemaClassName);
                return (Schema)oneOfClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOGGER.log(Level.WARNING, "Unable to create Schema class instance.", ex);
            }
        }
        return null;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator discriminator) {
        this.discriminator = discriminator;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<Object> getEnumeration() {
        return ModelUtils.readOnlyView(this.enumeration);
    }

    public void setEnumeration(List<Object> enumeration) {
        this.enumeration = ModelUtils.createList(enumeration);
    }

    public Schema addEnumeration(Object enumerationItem) {
        if (enumerationItem != null) {
            if (this.enumeration == null) {
                this.enumeration = ModelUtils.createList();
            }
            this.enumeration.add(enumerationItem);
        }
        return this;
    }

    public void removeEnumeration(Object enumeration) {
        if (this.enumeration != null) {
            this.enumeration.remove(enumeration);
        }
    }

    public BigDecimal getMultipleOf() {
        return this.multipleOf;
    }

    public void setMultipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public void setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
    }

    public List<String> getRequired() {
        return ModelUtils.readOnlyView(this.required);
    }

    public void setRequired(List<String> required) {
        this.required = ModelUtils.createList(required);
    }

    public Schema addRequired(String requiredItem) {
        if (requiredItem != null) {
            if (this.required == null) {
                this.required = ModelUtils.createList();
            }
            if (!this.required.contains(requiredItem)) {
                this.required.add(requiredItem);
            }
            Collections.sort(this.required);
        }
        return this;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void removeRequired(String required) {
        if (this.required != null) {
            this.required.remove(required);
        }
    }

    public Schema.SchemaType getType() {
        return this.type;
    }

    public void setType(Schema.SchemaType type) {
        this.type = type;
    }

    public Schema getNot() {
        return this.not;
    }

    public void setNot(Schema not) {
        this.not = not;
    }

    public Map<String, Schema> getProperties() {
        return ModelUtils.readOnlyView(this.properties);
    }

    public void setProperties(Map<String, Schema> properties) {
        this.properties = ModelUtils.createMap(properties);
    }

    public Schema addProperty(String key, Schema propertiesItem) {
        if (propertiesItem != null) {
            if (this.properties == null) {
                this.properties = ModelUtils.createMap();
            }
            this.properties.put(key, propertiesItem);
        }
        return this;
    }

    public void removeProperty(String key) {
        if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    @JsonIgnore
    public Schema getAdditionalPropertiesSchema() {
        return this.additionalProperties instanceof Schema ? (Schema)this.additionalProperties : null;
    }

    @JsonIgnore
    public Boolean getAdditionalPropertiesBoolean() {
        return this.additionalProperties instanceof Boolean ? (Boolean)this.additionalProperties : null;
    }

    public void setAdditionalPropertiesSchema(Schema additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setAdditionalPropertiesBoolean(Boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/schemas/" + ref;
        }
        this.ref = ref;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public void setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public XML getXml() {
        return this.xml;
    }

    public void setXml(XML xml) {
        this.xml = xml;
    }

    public Schema enumeration(List<Object> enumeration) {
        this.setEnumeration(enumeration);
        return this;
    }

    public Schema getItems() {
        return this.items;
    }

    public void setItems(Schema items) {
        this.items = items;
    }

    public List<Schema> getAllOf() {
        return ModelUtils.readOnlyView(this.allOf);
    }

    public void setAllOf(List<Schema> allOf) {
        this.allOf = ModelUtils.createList(allOf);
    }

    public Schema addAllOf(Schema allOf) {
        if (allOf != null) {
            if (this.allOf == null) {
                this.allOf = ModelUtils.createList();
            }
            this.allOf.add(allOf);
        }
        return this;
    }

    public void removeAllOf(Schema allOf) {
        if (this.allOf != null) {
            this.allOf.remove(allOf);
        }
    }

    public List<Schema> getAnyOf() {
        return ModelUtils.readOnlyView(this.anyOf);
    }

    public void setAnyOf(List<Schema> anyOf) {
        this.anyOf = ModelUtils.createList(anyOf);
    }

    public Schema addAnyOf(Schema anyOf) {
        if (anyOf != null) {
            if (this.anyOf == null) {
                this.anyOf = ModelUtils.createList();
            }
            this.anyOf.add(anyOf);
        }
        return this;
    }

    public void removeAnyOf(Schema anyOf) {
        if (this.anyOf != null) {
            this.anyOf.remove(anyOf);
        }
    }

    public List<Schema> getOneOf() {
        return ModelUtils.readOnlyView(this.oneOf);
    }

    public void setOneOf(List<Schema> oneOf) {
        this.oneOf = ModelUtils.createList(oneOf);
    }

    public Schema addOneOf(Schema oneOf) {
        if (oneOf != null) {
            if (this.oneOf == null) {
                this.oneOf = ModelUtils.createList();
            }
            this.oneOf.add(oneOf);
        }
        return this;
    }

    public void removeOneOf(Schema oneOf) {
        if (this.oneOf != null) {
            this.oneOf.remove(oneOf);
        }
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void merge(Schema from, Schema to, boolean override, ApiContext context) {
        Object fromImplementation;
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        if (from.getType() != null) {
            to.setType(ModelUtils.mergeProperty(to.getType(), from.getType(), override));
        }
        if (from instanceof SchemaImpl && to instanceof SchemaImpl && (fromImplementation = ((SchemaImpl)from).getImplementation()) != null) {
            SchemaImpl.setImplementation((SchemaImpl)to, (String)fromImplementation, override, context);
        }
        to.setDefaultValue(ModelUtils.mergeProperty(to.getDefaultValue(), from.getDefaultValue(), override));
        to.setTitle(ModelUtils.mergeProperty(to.getTitle(), from.getTitle(), override));
        if (from.getMultipleOf() != null && from.getMultipleOf().compareTo(BigDecimal.ZERO) > 0) {
            to.setMultipleOf(ModelUtils.mergeProperty(to.getMultipleOf(), from.getMultipleOf().stripTrailingZeros(), override));
        }
        if (from.getMaximum() != null) {
            to.setMaximum(ModelUtils.mergeProperty(to.getMaximum(), from.getMaximum(), override));
        }
        to.setExclusiveMaximum(ModelUtils.mergeProperty(to.getExclusiveMaximum(), from.getExclusiveMaximum(), override));
        if (from.getMinimum() != null) {
            to.setMinimum(ModelUtils.mergeProperty(to.getMinimum(), from.getMinimum(), override));
        }
        to.setExclusiveMinimum(ModelUtils.mergeProperty(to.getExclusiveMinimum(), from.getExclusiveMinimum(), override));
        to.setMaxLength(ModelUtils.mergeProperty(to.getMaxLength(), from.getMaxLength(), override));
        to.setMinLength(ModelUtils.mergeProperty(to.getMinLength(), from.getMinLength(), override));
        to.setPattern(ModelUtils.mergeProperty(to.getPattern(), from.getPattern(), override));
        to.setMaxItems(ModelUtils.mergeProperty(to.getMaxItems(), from.getMaxItems(), override));
        to.setMinItems(ModelUtils.mergeProperty(to.getMinItems(), from.getMinItems(), override));
        to.setUniqueItems(ModelUtils.mergeProperty(to.getUniqueItems(), from.getUniqueItems(), override));
        to.setMaxProperties(ModelUtils.mergeProperty(to.getMaxProperties(), from.getMaxProperties(), override));
        to.setMinProperties(ModelUtils.mergeProperty(to.getMinProperties(), from.getMinProperties(), override));
        if (from.getRequired() != null && !from.getRequired().isEmpty()) {
            if (to.getRequired() == null) {
                to.setRequired(ModelUtils.createList());
            }
            for (Object value : from.getRequired()) {
                if (to.getRequired().contains(value)) continue;
                to.addRequired((String)value);
            }
        }
        if (from.getProperties() != null && !from.getProperties().isEmpty()) {
            if (to.getProperties() == null) {
                to.setProperties(ModelUtils.createMap());
            }
            Map toProperties = to.getProperties();
            for (Map.Entry entry : from.getProperties().entrySet()) {
                String name = (String)entry.getKey();
                Schema fromSchema = (Schema)entry.getValue();
                if (!toProperties.containsKey(name)) {
                    to.addProperty(name, fromSchema);
                    continue;
                }
                Schema toSchema = (Schema)toProperties.get(name);
                SchemaImpl.merge(fromSchema, toSchema, override, context);
            }
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setFormat(ModelUtils.mergeProperty(to.getFormat(), from.getFormat(), override));
        to.setNullable(ModelUtils.mergeProperty(to.getNullable(), from.getNullable(), override));
        to.setReadOnly(ModelUtils.mergeProperty(to.getReadOnly(), from.getReadOnly(), override));
        to.setWriteOnly(ModelUtils.mergeProperty(to.getWriteOnly(), from.getWriteOnly(), override));
        to.setExample(ModelUtils.mergeProperty(to.getExample(), from.getExample(), override));
        if (from.getExternalDocs() != null) {
            if (to.getExternalDocs() == null) {
                to.setExternalDocs((ExternalDocumentation)new ExternalDocumentationImpl());
            }
            ExternalDocumentationImpl.merge(from.getExternalDocs(), to.getExternalDocs(), override);
        }
        to.setDeprecated(ModelUtils.mergeProperty(to.getDeprecated(), from.getDeprecated(), override));
        if (from.getEnumeration() != null && from.getEnumeration().size() > 0) {
            if (to.getEnumeration() == null) {
                to.setEnumeration(ModelUtils.createList());
            }
            for (Object value : from.getEnumeration()) {
                if (to.getEnumeration().contains(value)) continue;
                to.addEnumeration(value);
            }
        }
        if (from.getDiscriminator() != null) {
            if (to.getDiscriminator() == null) {
                to.setDiscriminator((Discriminator)new DiscriminatorImpl());
            }
            Discriminator discriminator = to.getDiscriminator();
            discriminator.setPropertyName(ModelUtils.mergeProperty(discriminator.getPropertyName(), from.getDiscriminator().getPropertyName(), override));
            for (Map.Entry entry : from.getDiscriminator().getMapping().entrySet()) {
                discriminator.addMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (from.getNot() != null) {
            to.setNot(from.getNot());
        }
        ModelUtils.mergeImmutableList(from.getAnyOf(), to.getAnyOf(), arg_0 -> ((Schema)to).setAnyOf(arg_0));
        ModelUtils.mergeImmutableList(from.getAllOf(), to.getAllOf(), arg_0 -> ((Schema)to).setAllOf(arg_0));
        ModelUtils.mergeImmutableList(from.getOneOf(), to.getOneOf(), arg_0 -> ((Schema)to).setOneOf(arg_0));
    }

    private static void setImplementation(SchemaImpl schema, String implementationClass, boolean override, ApiContext context) {
        if (context.getApi().getComponents().getSchemas() != null) {
            if (schema instanceof SchemaImpl) {
                schema.setImplementation(ModelUtils.mergeProperty(schema.getImplementation(), implementationClass, override));
            }
            if (implementationClass.endsWith("[]")) {
                implementationClass = implementationClass.substring(0, implementationClass.length() - 2);
                SchemaImpl itemSchema = new SchemaImpl();
                schema.setItems(itemSchema);
                schema.setType(Schema.SchemaType.ARRAY);
                schema = itemSchema;
            }
            if (!implementationClass.equals("java.lang.Void")) {
                Type type = context.getType(implementationClass);
                String schemaName = type != null ? ModelUtils.getSchemaName(context, (AnnotatedElement)type) : ModelUtils.getSimpleName(implementationClass);
                Schema copyFrom = (Schema)context.getApi().getComponents().getSchemas().get(schemaName);
                if (copyFrom == null) {
                    Schema.SchemaType schemaType = ModelUtils.getSchemaType(implementationClass, context);
                    copyFrom = new SchemaImpl().type(schemaType);
                }
                if (schema.getType() == Schema.SchemaType.ARRAY) {
                    schema.setItems(new SchemaImpl());
                    ModelUtils.merge(copyFrom, schema.getItems(), false);
                } else {
                    ModelUtils.merge(copyFrom, schema, false);
                }
                schema.setRef(null);
            }
        }
    }

    public static SchemaImpl fromImplementation(String implementationClass, ApiContext context) {
        SchemaImpl schema = new SchemaImpl();
        SchemaImpl.setImplementation(schema, implementationClass, true, context);
        return schema;
    }
}

