/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.attributes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.serialization.BeanHolder;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractInferringInjectionPointAttributes<T, S>
implements WeldInjectionPointAttributes<T, S>,
Serializable {
    private static final long serialVersionUID = 7820718127728549436L;
    private final BeanHolder<?> bean;
    private final Set<Annotation> qualifiers;
    private final TypeAttribute typeAttribute;
    private final boolean delegate;

    public AbstractInferringInjectionPointAttributes(EnhancedAnnotated<?, ?> annotatedElement, String contextId, Bean<?> bean, Set<Annotation> qualifiers, Class<?> declaringComponentClass) {
        this.bean = BeanHolder.of(contextId, bean);
        this.qualifiers = qualifiers;
        this.typeAttribute = bean == null ? new NonContextualInjectionPointTypeAttribute(declaringComponentClass) : new BeanInjectionPointTypeAttribute();
        this.delegate = annotatedElement.isAnnotationPresent(Delegate.class);
    }

    @Override
    public Type getType() {
        return this.typeAttribute.getType();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Bean<?> getBean() {
        return (Bean)this.bean.get();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isTransient() {
        return Reflections.isTransient(this.getMember());
    }

    @Override
    public abstract Member getMember();

    public String toString() {
        return this.getAnnotated().toString();
    }

    @Override
    public <X extends Annotation> X getQualifier(Class<X> annotationType) {
        X qualifier = this.getAnnotated().getAnnotation(annotationType);
        if (this.getQualifiers().contains(qualifier)) {
            return qualifier;
        }
        return null;
    }

    @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="The outer class is always serialized along this inner class.")
    private class NonContextualInjectionPointTypeAttribute
    extends TypeAttribute {
        private static final long serialVersionUID = 1870361474843082321L;
        private Class<?> componentClass;

        public NonContextualInjectionPointTypeAttribute(Class<?> componentClass) {
            this.componentClass = componentClass;
        }

        @Override
        protected Type resolveType() {
            return new HierarchyDiscovery(this.componentClass).resolveType(AbstractInferringInjectionPointAttributes.this.getAnnotated().getBaseType());
        }
    }

    @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="The outer class is always serialized along this inner class.")
    private class BeanInjectionPointTypeAttribute
    extends TypeAttribute {
        private static final long serialVersionUID = 6927120066961769765L;

        private BeanInjectionPointTypeAttribute() {
        }

        @Override
        protected Type resolveType() {
            return new HierarchyDiscovery(AbstractInferringInjectionPointAttributes.this.getBean().getBeanClass()).resolveType(AbstractInferringInjectionPointAttributes.this.getAnnotated().getBaseType());
        }
    }

    private abstract class TypeAttribute
    implements Serializable {
        private static final long serialVersionUID = -4558590047874880757L;
        private volatile transient Type type;

        private TypeAttribute() {
        }

        public Type getType() {
            if (this.type == null) {
                this.type = this.resolveType();
            }
            return this.type;
        }

        protected abstract Type resolveType();
    }
}

