/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.HttpMethod;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.glassfish.jersey.internal.util.ReflectionHelper;

class InterfaceUtil {
    private static final String PARAMETER_PARSE_REGEXP = "(?<=\\{).+?(?=\\})";
    private static final Pattern PATTERN = Pattern.compile("(?<=\\{).+?(?=\\})");

    InterfaceUtil() {
    }

    static List<String> parseParameters(String template) {
        ArrayList<String> allMatches = new ArrayList<String>();
        Matcher m = PATTERN.matcher(template);
        while (m.find()) {
            allMatches.add(m.group());
        }
        return allMatches;
    }

    static Method parseComputeMethod(Class<?> iClass, String[] headerValue) {
        List<String> computeMethodNames = InterfaceUtil.parseParameters(Arrays.toString(headerValue));
        if (headerValue.length > 1 && computeMethodNames.size() > 0) {
            throw new RestClientDefinitionException("@ClientHeaderParam annotation should not contain compute method when multiple values are present in value attribute. See " + iClass.getName());
        }
        if (computeMethodNames.size() == 1) {
            String methodName = computeMethodNames.get(0);
            List<Method> computeMethods = InterfaceUtil.getAnnotationComputeMethod(iClass, methodName);
            if (computeMethods.size() != 1) {
                throw new RestClientDefinitionException("No valid compute method found for name: " + methodName);
            }
            return computeMethods.get(0);
        }
        return null;
    }

    private static List<Method> getAnnotationComputeMethod(Class<?> iClass, String methodName) {
        if (methodName.contains(".")) {
            return InterfaceUtil.getStaticComputeMethod(methodName);
        }
        return InterfaceUtil.getComputeMethod(iClass, methodName);
    }

    private static List<Method> getStaticComputeMethod(String methodName) {
        int lastIndex = methodName.lastIndexOf(".");
        String className = methodName.substring(0, lastIndex);
        String staticMethodName = methodName.substring(lastIndex + 1);
        Class classWithStaticMethod = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)className));
        if (classWithStaticMethod == null) {
            throw new IllegalStateException("No class with following name found: " + className);
        }
        return InterfaceUtil.getComputeMethod(classWithStaticMethod, staticMethodName);
    }

    private static List<Method> getComputeMethod(Class<?> iClass, String methodName) {
        return Arrays.stream(iClass.getMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> method.isDefault() || Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(String.class) || method.getReturnType().equals(String[].class)).filter(method -> method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String.class)).collect(Collectors.toList());
    }

    static List<Class<?>> getHttpAnnotations(AnnotatedElement annotatedElement) {
        return Arrays.stream(annotatedElement.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().getAnnotation(HttpMethod.class) != null).map(Annotation::annotationType).collect(Collectors.toList());
    }
}

