/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.sse.InboundSseEvent;
import org.glassfish.jersey.client.ChunkParser;
import org.glassfish.jersey.client.ChunkedInput;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.microprofile.restclient.SseEventSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class SseEventPublisher
extends ChunkedInput<InboundEvent>
implements Publisher<InboundEvent> {
    private final Executor executor;
    private final Type genericType;
    private final int bufferSize;
    private static final ChunkParser SSE_EVENT_PARSER = ChunkedInput.createMultiParser((String[])new String[]{"\n\n", "\r\n\r\n"});
    private static final Logger LOG = Logger.getLogger(SseEventPublisher.class.getName());

    SseEventPublisher(InputStream inputStream, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, MessageBodyWorkers messageBodyWorkers, PropertiesDelegate propertiesDelegate, ExecutorService executor, int bufferSize) {
        super(InboundEvent.class, inputStream, annotations, mediaType, headers, messageBodyWorkers, propertiesDelegate);
        super.setParser(SSE_EVENT_PARSER);
        this.executor = executor;
        this.genericType = genericType;
        this.bufferSize = bufferSize;
    }

    public void subscribe(Subscriber subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber is `null`");
        }
        SseEventSubscription subscription = new SseEventSubscription(subscriber, this.bufferSize);
        subscriber.onSubscribe(subscription);
        Runnable readEventTask = () -> {
            if (this.genericType instanceof ParameterizedType) {
                Type typeArgument = ((ParameterizedType)this.genericType).getActualTypeArguments()[0];
                SseEventPublisher input = this;
                try {
                    if (typeArgument.equals(InboundSseEvent.class)) {
                        InboundEvent event;
                        while ((event = (InboundEvent)input.read()) != null) {
                            subscription.emit(event);
                        }
                    } else {
                        InboundEvent event;
                        while ((event = (InboundEvent)input.read()) != null) {
                            subscription.emit(event.readData((Class)typeArgument));
                        }
                    }
                }
                catch (Throwable t) {
                    subscription.onError(t);
                    return;
                }
                subscription.onCompletion();
            }
        };
        try {
            this.executor.execute(readEventTask);
        }
        catch (RejectedExecutionException e) {
            LOG.log(Level.WARNING, "Executor {0} rejected emit event task", this.executor);
        }
    }
}

