/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.rest.endpoints.config.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import fish.payara.appserver.rest.endpoints.RestEndpointModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardWrapper;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-rest-endpoints")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.GET, path="list-rest-endpoints", description="list-rest-endpoints", params={@RestParam(name="appname", value="$parent")})})
public class ListRestEndpointsCommand
implements AdminCommand {
    @Param(primary=true, alias="appName")
    private String appName = null;
    @Param(optional=true, alias="componentName")
    private String componentName = null;
    @Inject
    private ServiceLocator habitat;
    private final String jerseyWADL = "/application.wadl";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Map<String, Set<String>> endpoints = null;
        try {
            endpoints = this.getEndpointMap(this.appName);
        }
        catch (IllegalArgumentException ex) {
            report.setMessage(ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (endpoints.isEmpty()) {
            if (this.componentName == null) {
                report.setMessage("Application " + this.appName + " has no deployed endpoints");
            } else {
                report.setMessage("Component " + this.componentName + " has no deployed endpoints");
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        endpoints.forEach((path, methods) -> methods.forEach(method -> report.appendMessage(method + "\t" + path + "\n")));
        report.setMessage(report.getMessage().trim());
        Properties extraProps = new Properties();
        extraProps.put("endpoints", endpoints);
        report.setExtraProperties(extraProps);
    }

    public Map<String, Set<String>> getEndpointMap(String appName) {
        TreeMap<String, Set<String>> endpoints = new TreeMap<String, Set<String>>();
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.habitat.getService(ApplicationRegistry.class, new Annotation[0]);
        ApplicationInfo appInfo = this.getSpecifiedApplication(appName, appRegistry);
        if (appInfo == null) {
            throw new IllegalArgumentException("Application " + appName + " is not registered.");
        }
        List<WebModule> modules = this.getWebModules(appInfo);
        if (modules.isEmpty()) {
            throw new IllegalArgumentException("Application " + appName + " contains no web modules.");
        }
        Map<ServletContainer, String> jerseyApplicationMap = this.getSpecifiedJerseyApplications(this.componentName, modules);
        if (jerseyApplicationMap.isEmpty()) {
            if (this.componentName == null) {
                throw new IllegalArgumentException("Application " + appName + " has no deployed JAX-RS applications.");
            }
            throw new IllegalArgumentException("Component " + this.componentName + " could not be found.");
        }
        boolean hasEndpoints = false;
        for (Map.Entry<ServletContainer, String> entry : jerseyApplicationMap.entrySet()) {
            ServletContainer jerseyApplication = entry.getKey();
            String appRoot = jerseyApplication.getServletContext().getContextPath();
            String jerseyAppRoot = entry.getValue();
            List<Class<?>> containedClasses = this.getClasses(jerseyApplication);
            for (Class<?> containedClass : containedClasses) {
                List<RestEndpointModel> classEndpoints = this.getEndpointsForClass(containedClass);
                if (classEndpoints.isEmpty()) continue;
                for (RestEndpointModel endpoint : classEndpoints) {
                    String path = appRoot + jerseyAppRoot + endpoint.getPath();
                    String method = endpoint.getRequestMethod();
                    if (endpoints.keySet().contains(path)) {
                        Set methods = (Set)endpoints.get(path);
                        methods.add(method);
                        endpoints.put(path, methods);
                        continue;
                    }
                    endpoints.put(path, new TreeSet<String>(Arrays.asList(method)));
                }
            }
            endpoints.put(appRoot + jerseyAppRoot + "/application.wadl", new TreeSet<String>(Arrays.asList("GET")));
            hasEndpoints = true;
        }
        if (!hasEndpoints) {
            return null;
        }
        return endpoints;
    }

    private ApplicationInfo getSpecifiedApplication(String appName, ApplicationRegistry appRegistry) {
        if (appRegistry == null || appName == null) {
            return null;
        }
        for (String applicationRegistryNameEntry : appRegistry.getAllApplicationNames()) {
            if (!applicationRegistryNameEntry.equals(appName)) continue;
            return appRegistry.get(applicationRegistryNameEntry);
        }
        return null;
    }

    private List<WebModule> getWebModules(ApplicationInfo appInfo) {
        if (appInfo == null) {
            return null;
        }
        ArrayList<WebModule> webModules = new ArrayList<WebModule>();
        for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
            WebApplication webApplication;
            EngineRef engineRef = moduleInfo.getEngineRefForContainer(WebContainer.class);
            if (engineRef == null || (webApplication = (WebApplication)engineRef.getApplicationContainer()) == null) continue;
            for (WebModule module : webApplication.getWebModules()) {
                webModules.add(module);
            }
        }
        return webModules;
    }

    private Map<ServletContainer, String> getSpecifiedJerseyApplications(String componentName, List<WebModule> modules) {
        HashMap<ServletContainer, String> jerseyApplicationMap = new HashMap<ServletContainer, String>();
        for (WebModule webModule : modules) {
            for (Container container : webModule.findChildren()) {
                StandardWrapper servlet;
                if (!(container instanceof StandardWrapper) || (servlet = (StandardWrapper)container).getServletClass() != ServletContainer.class || !(componentName == null ^ servlet.getName().equals(componentName))) continue;
                Collection mappings = servlet.getMappings();
                String servletMapping = null;
                if (mappings.size() > 0) {
                    servletMapping = mappings.toArray()[0].toString().replaceAll("/\\*", "");
                }
                jerseyApplicationMap.put((ServletContainer)servlet.getServlet(), servletMapping);
            }
        }
        return jerseyApplicationMap;
    }

    private List<Class<?>> getClasses(ServletContainer jerseyApplication) {
        ArrayList classes = new ArrayList();
        for (Class jerseyClass : jerseyApplication.getConfiguration().getApplication().getClasses()) {
            if (jerseyClass.getPackage() != null && jerseyClass.getPackage().getName().contains("org.glassfish.jersey.server.wadl")) continue;
            classes.add(jerseyClass);
        }
        return classes;
    }

    private List<RestEndpointModel> getEndpointsForClass(Class containerClass) {
        ArrayList<RestEndpointModel> endpoints = new ArrayList<RestEndpointModel>();
        for (Method method : containerClass.getDeclaredMethods()) {
            RestEndpointModel endpoint = RestEndpointModel.generateFromMethod(method);
            if (endpoint == null) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }
}

