/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm;

import fish.payara.security.api.CertificateCredential;
import java.security.cert.X509Certificate;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.credential.AbstractClearableCredential;

public class CertificateCredentialImpl
extends AbstractClearableCredential
implements CertificateCredential {
    private X509Certificate[] certificates;

    public CertificateCredentialImpl(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            throw new IllegalArgumentException("Certificates can't be empty.");
        }
        this.certificates = certs;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public CallerPrincipal getPrincipal() {
        return new CallerPrincipal(this.certificates[0].getIssuerDN().getName());
    }

    public void clearCredential() {
        this.certificates = null;
    }
}

