/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifier;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-notifiers")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="notifier.list.services")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-notifiers", description="Lists the names of all available notifier services")})
public class NotifierServiceLister
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(NotifierServiceLister.class);
    @Inject
    private ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List allServiceHandles = this.habitat.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        if (allServiceHandles.isEmpty()) {
            report.appendMessage(strings.getLocalString("notifier.list.services.warning", "No registered notifier service found."));
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(strings.getLocalString("notifier.list.services.availability.info", "Available Notifier Services") + ":\n");
            Properties extrasProps = new Properties();
            ArrayList<String> names = new ArrayList<String>();
            for (ServiceHandle serviceHandle : allServiceHandles) {
                String notifierName = NotifierUtils.getNotifierName(serviceHandle.getActiveDescriptor());
                sb.append("\t" + notifierName + "\n");
                names.add(notifierName);
            }
            extrasProps.put("availableServices", names);
            report.setMessage(sb.toString());
            report.setExtraProperties(extrasProps);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

