/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.loader.StandardClassLoader;

public final class ClassLoaderFactory {
    private static final Logger log = LogFacade.getLogger();
    private static int debug = 0;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        return ClassLoaderFactory.createClassLoader(unpacked, packed, null, parent);
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, URL[] urls, ClassLoader parent) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (unpacked != null) {
            for (File file : unpacked) {
                if (!file.exists() || !file.canRead()) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Including directory or JAR {0}", file.getAbsolutePath());
                }
                URL url = new URL("file", null, file.getCanonicalPath() + File.separator);
                set.add(url);
            }
        }
        if (packed != null) {
            for (int i = 0; i < packed.length; ++i) {
                String[] filenames;
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                for (String filename1 : filenames = directory.list()) {
                    String filename = filename1.toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filename1);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Including jar file {0}", file.getAbsolutePath());
                    }
                    URL url = new URL("file", null, file.getCanonicalPath());
                    set.add(url);
                }
            }
        }
        if (urls != null) {
            set.addAll(Arrays.asList(urls));
        }
        final URL[] array = set.toArray(new URL[set.size()]);
        final ClassLoader parentCL = parent;
        StandardClassLoader classLoader = null;
        classLoader = parentCL == null ? AccessController.doPrivileged(new PrivilegedAction<StandardClassLoader>(){

            @Override
            public StandardClassLoader run() {
                return new StandardClassLoader(array);
            }
        }) : AccessController.doPrivileged(new PrivilegedAction<StandardClassLoader>(){

            @Override
            public StandardClassLoader run() {
                return new StandardClassLoader(array, parentCL);
            }
        });
        classLoader.setDelegate(true);
        return classLoader;
    }
}

