/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

public class URLPattern
implements Comparable {
    public static final int PT_DEFAULT = 0;
    public static final int PT_EXTENSION = 1;
    public static final int PT_PREFIX = 2;
    public static final int PT_EXACT = 3;
    private static String DEFAULT_PATTERN = "/";
    private final String pattern;
    private int patternType = -1;

    public URLPattern() {
        this.pattern = DEFAULT_PATTERN;
        this.patternType = 0;
    }

    public URLPattern(String urlPattern) {
        if (urlPattern == null) {
            this.pattern = DEFAULT_PATTERN;
            this.patternType = 0;
        } else {
            this.pattern = urlPattern;
        }
    }

    public int patternType() {
        if (this.patternType < 0) {
            this.patternType = this.pattern.startsWith("*.") ? 1 : (this.pattern.startsWith("/") && this.pattern.endsWith("/*") ? 2 : (this.pattern.equals(DEFAULT_PATTERN) ? 0 : 3));
        }
        return this.patternType;
    }

    public int compareTo(Object object) {
        if (!(object instanceof URLPattern)) {
            throw new ClassCastException("Argument must be URLPattern");
        }
        URLPattern urlPattern = (URLPattern)object;
        int refPatternType = this.patternType();
        int result = refPatternType - urlPattern.patternType();
        if (result == 0) {
            if (refPatternType == 2 || refPatternType == 3) {
                result = this.getPatternDepth() - urlPattern.getPatternDepth();
                if (result == 0) {
                    result = this.pattern.compareTo(urlPattern.pattern);
                }
            } else {
                result = this.pattern.compareTo(urlPattern.pattern);
            }
        }
        return result > 0 ? 1 : (result < 0 ? -1 : 0);
    }

    public boolean implies(URLPattern urlPattern) {
        String path;
        String currentPattern;
        if (urlPattern == null) {
            urlPattern = new URLPattern(null);
        }
        if ((currentPattern = this.pattern).equals(path = urlPattern.pattern)) {
            return true;
        }
        if (currentPattern.startsWith("/") && currentPattern.endsWith("/*")) {
            int length = (currentPattern = currentPattern.substring(0, currentPattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(currentPattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (currentPattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(currentPattern.substring(1));
        }
        return currentPattern.equals(DEFAULT_PATTERN);
    }

    public int getPatternDepth() {
        int i = 0;
        int depth = 1;
        while (i >= 0) {
            if ((i = this.pattern.indexOf("/", i)) < 0) continue;
            if (i == 0 && depth != 1) {
                throw new IllegalArgumentException("// in pattern");
            }
            ++i;
        }
        return depth;
    }

    public static boolean match(String originalPattern, String newPattern) {
        URLPattern original = new URLPattern(originalPattern);
        URLPattern comparedPattern = new URLPattern(newPattern);
        return original.implies(comparedPattern);
    }

    public boolean equals(Object object) {
        if (!(object instanceof URLPattern)) {
            return false;
        }
        return this.pattern.equals(((URLPattern)object).pattern);
    }

    public String toString() {
        return this.pattern;
    }
}

