/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.glassfish.ha.common.GlassFishHAReplicaPredictor;
import org.glassfish.ha.common.HACookieInfo;
import org.glassfish.ha.common.HACookieManager;
import org.glassfish.ha.common.NoopHAReplicaPredictor;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.ha.session.management.HANonStorableSession;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.WebEventPersistentManager;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ReplicationWebEventPersistentManager<T extends Storeable>
extends ReplicationManagerBase<T>
implements WebEventPersistentManager {
    @Inject
    private ServiceLocator services;
    private GlassFishHAReplicaPredictor predictor;
    private String clusterName = "";
    private String instanceName = "";
    private static final String info = "ReplicationWebEventPersistentManager/1.0";
    private static final String name = "ReplicationWebEventPersistentManager";
    private static int _messageIDCounter = 0;

    public String getInfo() {
        return info;
    }

    public ReplicationWebEventPersistentManager() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("ReplicationWebEventPersistentManager created");
        }
    }

    public void add(Session session) {
        if (!(session instanceof HANonStorableSession)) {
            super.add(session);
        }
    }

    @Override
    public void doValveSave(Session session) {
        if (session instanceof HANonStorableSession) {
            return;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("in doValveSave");
        }
        try {
            ReplicationStore replicationStore = (ReplicationStore)this.getStore();
            replicationStore.doValveSave(session);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("FINISHED repStore.valveSave");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._logger.log(Level.FINE, "exception occurred in doValveSave id=" + session.getIdInternal(), ex);
        }
    }

    public void postRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
        Session sess = this.getSession(request);
        if (sess != null) {
            this.doValveSave(sess);
        }
    }

    private Session getSession(ServletRequest request) {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpSession httpSess = httpReq.getSession(false);
        if (httpSess == null) {
            return null;
        }
        String id = httpSess.getId();
        Session sess = null;
        try {
            sess = this.findSession(id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sess;
    }

    public String getName() {
        return name;
    }

    protected void processMaxIdleBackups() {
    }

    protected void processMaxActiveSwaps() {
    }

    protected void processMaxIdleSwaps() {
    }

    @Override
    public String getReplicaFromPredictor(String sessionId, String oldJreplicaValue) {
        if (this.isDisableJreplica()) {
            return null;
        }
        String gmsClusterName = "";
        HazelcastCore hazelcast = (HazelcastCore)this.services.getService(HazelcastCore.class, new Annotation[0]);
        if (hazelcast.isEnabled()) {
            gmsClusterName = hazelcast.getMemberGroup();
        }
        HACookieInfo cookieInfo = this.predictor.makeCookie(gmsClusterName, (Object)sessionId, oldJreplicaValue);
        HACookieManager.setCurrrent((HACookieInfo)cookieInfo);
        return cookieInfo.getNewReplicaCookie();
    }

    @Override
    public void createBackingStore(String persistenceType, String storeName, Class<T> metadataClass, Map<String, Object> vendorMap) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Create backing store invoked with persistence type " + persistenceType + " and store name " + storeName);
        }
        BackingStoreFactory factory = (BackingStoreFactory)this.services.getService(BackingStoreFactory.class, persistenceType, new Annotation[0]);
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        HazelcastCore hazelcast = (HazelcastCore)this.services.getService(HazelcastCore.class, new Annotation[0]);
        if (hazelcast.isEnabled()) {
            this.clusterName = hazelcast.getMemberGroup();
            this.instanceName = hazelcast.getMemberName();
        }
        conf.setStoreName(storeName).setClusterName(this.clusterName).setInstanceName(this.instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(metadataClass).setClassLoader(this.getClass().getClassLoader());
        if (vendorMap != null) {
            conf.getVendorSpecificSettings().putAll(vendorMap);
        }
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("About to create backing store " + conf);
            }
            this.backingStore = factory.createBackingStore(conf);
        }
        catch (BackingStoreException e) {
            this._logger.log(Level.WARNING, "AS-WEB-HA-00008", e);
        }
        Object obj = conf.getVendorSpecificSettings().get("key.mapper");
        if (obj != null && obj instanceof GlassFishHAReplicaPredictor) {
            this.predictor = (GlassFishHAReplicaPredictor)obj;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("ReplicatedManager.keymapper is " + this.predictor);
            }
        } else {
            this.predictor = new NoopHAReplicaPredictor();
        }
    }
}

