/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.sampling;

import java.util.Random;
import java.util.logging.Logger;

public class SampleFilter {
    private static final Logger LOGGER = Logger.getLogger(SampleFilter.class.getName());
    protected double sampleRate;
    private volatile Random random = new Random();

    public SampleFilter(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public SampleFilter() {
        this(1.0);
    }

    public boolean sample() {
        boolean sample;
        double randomDouble = this.random.nextDouble();
        boolean bl = sample = randomDouble < this.sampleRate;
        if (sample) {
            LOGGER.finest(String.format("Request was traced as sample rate was: %4.1f and the random float was: %4.1f", this.sampleRate, randomDouble));
        } else {
            LOGGER.finest(String.format("Request wasn't traced as sample rate was: %4.1f but the random float was: %4.1f", this.sampleRate, randomDouble));
        }
        return sample;
    }
}

