/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.store;

import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreInterface;
import fish.payara.nucleus.requesttracing.store.strategy.TraceStorageStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;

public class ClusteredRequestTraceStore
implements RequestTraceStoreInterface,
Serializable {
    private final Map<UUID, RequestTrace> store;
    private IntSupplier maxStoreSize;
    private final TraceStorageStrategy strategy;

    ClusteredRequestTraceStore(Map<UUID, RequestTrace> store, TraceStorageStrategy strategy) {
        this.store = store;
        this.maxStoreSize = () -> store.size();
        this.strategy = strategy;
    }

    @Override
    public RequestTrace addTrace(RequestTrace trace) {
        return this.addTrace(trace, null);
    }

    @Override
    public RequestTrace addTrace(RequestTrace trace, RequestTrace traceToRemove) {
        this.store.put(trace.getTraceId(), trace);
        traceToRemove = this.strategy.getTraceForRemoval(this.getTraces(), this.maxStoreSize.getAsInt(), traceToRemove);
        if (traceToRemove == null) {
            return null;
        }
        this.store.remove(traceToRemove.getTraceId());
        return traceToRemove;
    }

    @Override
    public Collection<RequestTrace> getTraces() {
        return this.store.values();
    }

    @Override
    public Collection<RequestTrace> getTraces(int limit) {
        return this.store.values().stream().limit(limit).collect(Collectors.toList());
    }

    @Override
    public void setSize(IntSupplier maxSize) {
        int currentMaxSize = maxSize.getAsInt();
        while (this.store.size() > currentMaxSize) {
            this.store.remove(this.strategy.getTraceForRemoval(this.getTraces(), currentMaxSize, null).getTraceId());
        }
        this.maxStoreSize = maxSize;
    }

    @Override
    public int getStoreSize() {
        return this.maxStoreSize.getAsInt();
    }

    @Override
    public Collection<RequestTrace> emptyStore() {
        ArrayList<RequestTrace> traces = new ArrayList<RequestTrace>(this.store.values());
        this.store.clear();
        return traces;
    }

    @Override
    public boolean isShared() {
        return true;
    }
}

