/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.store;

import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreInterface;
import fish.payara.nucleus.requesttracing.store.strategy.TraceStorageStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;

public class LocalRequestTraceStore
implements RequestTraceStoreInterface {
    private final Set<RequestTrace> store = ConcurrentHashMap.newKeySet();
    private IntSupplier maxStoreSize = () -> 0;
    private final TraceStorageStrategy strategy;

    LocalRequestTraceStore(TraceStorageStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public RequestTrace addTrace(RequestTrace trace) {
        return this.addTrace(trace, null);
    }

    @Override
    public RequestTrace addTrace(RequestTrace trace, RequestTrace traceToRemove) {
        this.store.add(trace);
        traceToRemove = this.strategy.getTraceForRemoval(this.getTraces(), this.maxStoreSize.getAsInt(), traceToRemove);
        if (traceToRemove == null) {
            return null;
        }
        this.store.remove(traceToRemove);
        return traceToRemove;
    }

    @Override
    public Collection<RequestTrace> getTraces() {
        return this.store;
    }

    @Override
    public Collection<RequestTrace> getTraces(int limit) {
        return this.store.stream().limit(limit).collect(Collectors.toList());
    }

    @Override
    public void setSize(IntSupplier maxSize) {
        int currentMaxSize = maxSize.getAsInt();
        while (this.store.size() > currentMaxSize) {
            this.store.remove(this.strategy.getTraceForRemoval(this.getTraces(), currentMaxSize, null));
        }
        this.maxStoreSize = maxSize;
    }

    @Override
    public int getStoreSize() {
        return this.maxStoreSize.getAsInt();
    }

    @Override
    public Collection<RequestTrace> emptyStore() {
        ArrayList<RequestTrace> traces = new ArrayList<RequestTrace>(this.store);
        this.store.clear();
        return traces;
    }
}

