/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;

@JsonSerialize(using=ExtensibleTreeMapSerializer.class)
public abstract class ExtensibleTreeMap<V, T extends Extensible<T>>
extends TreeMap<String, V>
implements Extensible<T> {
    @JsonIgnore
    protected Map<String, Object> extensions = ModelUtils.createMap();

    protected ExtensibleTreeMap() {
    }

    protected ExtensibleTreeMap(Map<String, ? extends V> items) {
        super(items);
    }

    public final Map<String, Object> getExtensions() {
        return ModelUtils.readOnlyView(this.extensions);
    }

    public final void setExtensions(Map<String, Object> extensions) {
        this.extensions.clear();
        for (Map.Entry<String, Object> entry : extensions.entrySet()) {
            this.extensions.put(ExtensibleImpl.extensionName(entry.getKey()), entry.getValue());
        }
    }

    public final T addExtension(String name, Object value) {
        if (value != null) {
            this.extensions.put(ExtensibleImpl.extensionName(name), value);
        }
        return (T)this;
    }

    public final void removeExtension(String name) {
        this.extensions.remove(ExtensibleImpl.extensionName(name));
    }

    static class ExtensibleTreeMapSerializer
    extends JsonSerializer<ExtensibleTreeMap<?, ?>> {
        ExtensibleTreeMapSerializer() {
        }

        public void serialize(ExtensibleTreeMap<?, ?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Reference reference;
            String ref;
            if (value instanceof Reference && (ref = (reference = (Reference)value).getRef()) != null) {
                gen.writeStartObject(value);
                gen.writeFieldName("$ref");
                gen.writeString(ref);
                gen.writeEndObject();
                return;
            }
            gen.writeStartObject(value);
            ParameterizedType mapType = (ParameterizedType)value.getClass().getGenericSuperclass();
            Class valueType = (Class)mapType.getActualTypeArguments()[0];
            JsonSerializer valueSerializer = serializers.findValueSerializer(valueType);
            for (Map.Entry entry : value.entrySet()) {
                gen.writeFieldName((String)entry.getKey());
                valueSerializer.serialize(entry.getValue(), gen, serializers);
            }
            for (Map.Entry<Object, Object> entry : value.getExtensions().entrySet()) {
                gen.writeFieldName((String)entry.getKey());
                Object extensionValue = entry.getValue();
                serializers.findValueSerializer(extensionValue.getClass()).serialize(extensionValue, gen, serializers);
            }
            gen.writeEndObject();
        }
    }
}

