/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.parameters;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.EnumModel;

public class ParameterImpl
extends ExtensibleImpl<Parameter>
implements Parameter {
    private String name;
    private Parameter.In in;
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private String ref;
    private Parameter.Style style;
    private Boolean explode;
    private Boolean allowReserved;
    private Schema schema;
    private Map<String, Example> examples = ModelUtils.createMap();
    private Object example;
    private Content content = new ContentImpl();
    private List<ContentImpl> contents = ModelUtils.createList();

    public static Parameter createInstance(AnnotationModel annotation, ApiContext context) {
        Boolean hidden;
        EnumModel styleEnum;
        ParameterImpl from = new ParameterImpl();
        from.setName((String)annotation.getValue("name", String.class));
        EnumModel inEnum = (EnumModel)annotation.getValue("in", EnumModel.class);
        if (inEnum != null) {
            from.setIn(Parameter.In.valueOf((String)inEnum.getValue()));
        }
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setRequired((Boolean)annotation.getValue("required", Boolean.class));
        from.setDeprecated((Boolean)annotation.getValue("deprecated", Boolean.class));
        from.setAllowEmptyValue((Boolean)annotation.getValue("allowEmptyValue", Boolean.class));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        if ((styleEnum = (EnumModel)annotation.getValue("style", EnumModel.class)) != null) {
            from.setStyle(Parameter.Style.valueOf((String)styleEnum.getValue()));
        }
        from.setExplode((Boolean)annotation.getValue("explode", Boolean.class));
        from.setAllowReserved((Boolean)annotation.getValue("allowReserved", Boolean.class));
        AnnotationModel schemaAnnotation = (AnnotationModel)annotation.getValue("schema", AnnotationModel.class);
        if (!(schemaAnnotation == null || (hidden = (Boolean)schemaAnnotation.getValue("hidden", Boolean.class)) != null && hidden.booleanValue())) {
            from.setSchema(SchemaImpl.createInstance(schemaAnnotation, context));
        }
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, from::addExample);
        from.setExample(annotation.getValue("example", Object.class));
        List<ContentImpl> contents = ModelUtils.createList();
        ModelUtils.extractAnnotations(annotation, context, "content", ContentImpl::createInstance, contents::add);
        for (ContentImpl content : contents) {
            content.getMediaTypes().forEach((arg_0, arg_1) -> ((Content)from.content).addMediaType(arg_0, arg_1));
        }
        return from;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Parameter.In getIn() {
        return this.in;
    }

    public void setIn(Parameter.In in) {
        this.in = in;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    public Parameter.Style getStyle() {
        return this.style;
    }

    public void setStyle(Parameter.Style style) {
        this.style = style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Map<String, Example> getExamples() {
        return ModelUtils.readOnlyView(this.examples);
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples == null ? null : ModelUtils.createMap(examples);
    }

    public Parameter addExample(String key, Example example) {
        if (example != null) {
            if (this.examples == null) {
                this.examples = ModelUtils.createMap();
            }
            this.examples.put(key, example);
        }
        return this;
    }

    public void removeExample(String key) {
        if (this.examples != null) {
            this.examples.remove(key);
        }
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public List<ContentImpl> getContents() {
        return ModelUtils.readOnlyView(this.contents);
    }

    public void setContents(List<ContentImpl> contents) {
        this.contents = ModelUtils.createList(contents);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/parameters/" + ref;
        }
        this.ref = ref;
    }

    public static void merge(Parameter from, Parameter to, boolean override, ApiContext context) {
        ParameterImpl fromImpl;
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setName(ModelUtils.mergeProperty(to.getName(), from.getName(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        if (from.getIn() != null) {
            to.setIn(ModelUtils.mergeProperty(to.getIn(), from.getIn(), override));
        }
        to.setRequired(ModelUtils.mergeProperty(to.getRequired(), from.getRequired(), override));
        to.setDeprecated(ModelUtils.mergeProperty(to.getDeprecated(), from.getDeprecated(), override));
        to.setAllowEmptyValue(ModelUtils.mergeProperty(to.getAllowEmptyValue(), from.getAllowEmptyValue(), override));
        if (from.getStyle() != null) {
            to.setStyle(ModelUtils.mergeProperty(to.getStyle(), from.getStyle(), override));
        }
        if (from.getExplode() != null) {
            to.setExplode(ModelUtils.mergeProperty(to.getExplode(), false, override));
        }
        to.setAllowReserved(ModelUtils.mergeProperty(to.getAllowReserved(), from.getAllowReserved(), override));
        if (from.getSchema() != null) {
            if (to.getSchema() == null) {
                to.setSchema((Schema)new SchemaImpl());
            }
            SchemaImpl.merge(from.getSchema(), to.getSchema(), override, context);
        }
        to.setExample(ModelUtils.mergeProperty(to.getExample(), from.getExample(), override));
        if (from.getExamples() != null) {
            for (String exampleName : from.getExamples().keySet()) {
                if (exampleName == null) continue;
                ExampleImpl example = new ExampleImpl();
                ExampleImpl.merge((Example)from.getExamples().get(exampleName), example, override);
                to.addExample(exampleName, (Example)example);
            }
        }
        if (from instanceof ParameterImpl && (fromImpl = (ParameterImpl)from).getContents() != null) {
            if (to.getContent() == null) {
                to.setContent((Content)new ContentImpl());
            }
            for (ContentImpl content : fromImpl.getContents()) {
                ContentImpl.merge(content, to.getContent(), override, context);
            }
        }
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent((Content)new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
    }
}

