/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.processor;

import fish.payara.microprofile.openapi.api.processor.OASProcessor;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class ConfigPropertyProcessor
implements OASProcessor {
    @Override
    public OpenAPI process(OpenAPI api, OpenApiConfiguration config) {
        for (Map.Entry<String, SchemaImpl> schemaEntry : config.getSchemaMap().entrySet()) {
            SchemaImpl schema = schemaEntry.getValue();
            String schemaClassName = schemaEntry.getKey();
            schema.setImplementation(schemaClassName);
            String schemaName = schema.getName();
            if (schemaName == null || schemaName.isEmpty()) {
                schemaName = ModelUtils.getSimpleName(schemaClassName);
            }
            api.getComponents().addSchema(schemaName, (Schema)schema);
        }
        return api;
    }
}

