/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.persistence.eclipselink.cache.coordination;

import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.persistence.eclipselink.cache.coordination.HazelcastPayload;
import fish.payara.persistence.eclipselink.cache.coordination.HazelcastTopic;
import fish.payara.persistence.eclipselink.cache.coordination.HazelcastTopicStorage;
import org.eclipse.persistence.internal.sessions.coordination.broadcast.BroadcastRemoteConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;

public class HazelcastTopicRemoteConnection
extends BroadcastRemoteConnection
implements MessageReceiver<HazelcastPayload> {
    private final HazelcastTopic topic;

    HazelcastTopicRemoteConnection(RemoteCommandManager rcm) {
        super(rcm);
        this.topic = new HazelcastTopic(rcm.getChannel(), this);
    }

    protected Object executeCommandInternal(Object o) throws Exception {
        if (o != null) {
            Object[] debugInfo = null;
            if (this.rcm.shouldLogDebugMessage()) {
                debugInfo = this.logDebugBeforePublish(null);
            }
            if (Command.class.isAssignableFrom(o.getClass())) {
                this.topic.publish(new HazelcastPayload.Command((Command)o));
            } else if (o.getClass().isArray()) {
                this.topic.publish(new HazelcastPayload.Bytes((byte[])o));
            }
            if (debugInfo != null) {
                this.logDebugAfterPublish(debugInfo, "");
            }
        }
        return null;
    }

    protected void closeInternal() throws Exception {
        this.topic.destroy();
    }

    public void receiveMessage(ClusterMessage<HazelcastPayload> message) {
        HazelcastPayload payload = (HazelcastPayload)message.getPayload();
        if (!this.topic.hasPublished(payload)) {
            HazelcastTopicStorage.getInstance().process(() -> {
                try {
                    this.processReceivedObject(payload.getCommand(this.rcm), payload.getId().toString());
                }
                catch (Exception e) {
                    this.failDeserializeMessage(payload.getId().toString(), e);
                }
            });
        }
    }
}

