/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.regex.Pattern;

public final class RegexUtil {
    private static final char BACKSLASH = '\\';
    private static final String REGEX_SPECIALS = "\\[]^$?+{}()|-!";

    private RegexUtil() {
    }

    public static Pattern[] exprsToPatterns(String[] exprs) {
        return RegexUtil.exprsToPatterns(exprs, 0);
    }

    public static Pattern[] exprsToPatterns(String[] exprs, int flags) {
        Pattern[] patterns = new Pattern[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            patterns[i] = Pattern.compile(RegexUtil.wildcardToJavaRegex(exprs[i]), flags);
        }
        return patterns;
    }

    public static String wildcardToJavaRegex(String input) {
        String converted = input;
        if (input != null) {
            int length = input.length();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                char theChar = input.charAt(i);
                if (theChar == '.') {
                    buf.append("[.]");
                    continue;
                }
                if (theChar == '*') {
                    buf.append(".*");
                    continue;
                }
                if (REGEX_SPECIALS.indexOf(theChar) >= 0) {
                    buf.append("").append('\\').append(theChar);
                    continue;
                }
                buf.append(theChar);
            }
            converted = buf.toString();
        }
        return converted;
    }
}

