/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.opentracing;

import fish.payara.ejb.opentracing.OpenTracingIiopTextMap;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public class OpenTracingIiopClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private OpenTracingService openTracingService;
    private Tracer tracer;

    public OpenTracingIiopClientInterceptor(OpenTracingService openTracingService) {
        this.openTracingService = openTracingService;
        this.tracer = GlobalTracer.get();
        GlobalTracer.registerIfAbsent(() -> openTracingService.getTracer("__PAYARA_CORBA_RMI"));
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        GlobalTracer.registerIfAbsent(() -> this.openTracingService.getTracer("__PAYARA_CORBA_RMI"));
        if (!GlobalTracer.isRegistered()) {
            return;
        }
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan == null) {
            return;
        }
        OpenTracingIiopTextMap textMap = new OpenTracingIiopTextMap();
        this.tracer.inject(activeSpan.context(), Format.Builtin.TEXT_MAP, (Object)textMap);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(textMap);
            out.flush();
            ServiceContext serviceContext = new ServiceContext(3226428, bos.toByteArray());
            clientRequestInfo.add_request_service_context(serviceContext, true);
        }
        catch (IOException ex) {
            Logger.getLogger(OpenTracingIiopClientInterceptor.class.getName()).log(Level.SEVERE, "Exception caught propagating span context");
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void destroy() {
    }
}

