/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.policy.AsynchronousPolicy;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceExecutionContext;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceRequestTracing;
import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class FaultToleranceMethodContextImpl
implements FaultToleranceMethodContext {
    private static final Logger logger = Logger.getLogger(FaultToleranceMethodContextImpl.class.getName());
    private final FaultToleranceMethodState shared;
    private final InvocationContext context;
    private final FaultTolerancePolicy policy;
    private final String appName;

    public String getAppName() {
        return this.appName;
    }

    public FaultToleranceMethodContextImpl(RequestContextController requestContext, FaultToleranceRequestTracing requestTracing, FaultToleranceMetrics metrics, ExecutorService asyncExecution, ScheduledExecutorService delayedExecution, String appName) {
        this(new FaultToleranceMethodState(requestContext, requestTracing, metrics, asyncExecution, delayedExecution), appName, null, null);
    }

    private FaultToleranceMethodContextImpl(FaultToleranceMethodState shared, String appName, InvocationContext context, FaultTolerancePolicy policy) {
        this.shared = shared;
        this.context = context;
        this.policy = policy;
        this.appName = appName;
        shared.lastUsed.accumulateAndGet(System.currentTimeMillis(), Long::max);
    }

    @Override
    public FaultToleranceMethodContext boundTo(InvocationContext context, FaultTolerancePolicy policy) {
        return new FaultToleranceMethodContextImpl(this.shared, this.appName, context, policy);
    }

    @Override
    public Object proceed() throws Exception {
        try {
            int in = this.shared.executingThreadCount.incrementAndGet();
            if (this.policy.isBulkheadPresent() && in > this.policy.bulkhead.value) {
                logger.log(Level.WARNING, "Bulkhead appears to have been breached, now executing {0} for method {1}", new Object[]{in, this.context.getMethod()});
            }
            Object object = this.context.proceed();
            return object;
        }
        finally {
            this.shared.executingThreadCount.decrementAndGet();
        }
    }

    @Override
    public FaultToleranceMetrics getMetrics() {
        return this.policy.isMetricsEnabled ? this.shared.metrics : FaultToleranceMetrics.DISABLED;
    }

    @Override
    public CircuitBreakerState getState() {
        int requestVolumeThreshold = this.policy.circuitBreaker.requestVolumeThreshold;
        return requestVolumeThreshold < 0 ? this.shared.circuitBreakerState.get() : this.shared.circuitBreakerState.updateAndGet(value -> value != null ? value : new CircuitBreakerState(requestVolumeThreshold, this.policy.circuitBreaker.failureRatio));
    }

    @Override
    public BlockingQueue<Thread> getConcurrentExecutions() {
        int maxConcurrentThreads = this.policy.bulkhead.value;
        return maxConcurrentThreads < 0 ? this.shared.concurrentExecutions.get() : this.shared.concurrentExecutions.updateAndGet(value -> value != null ? value : new ArrayBlockingQueue(maxConcurrentThreads));
    }

    @Override
    public AtomicInteger getQueuingOrRunningPopulation() {
        return this.shared.queuingOrRunningPopulation;
    }

    @Override
    public void delay(long delayMillis) throws InterruptedException {
        if (delayMillis <= 0L) {
            return;
        }
        this.trace("delayRetry");
        try {
            Thread.sleep(delayMillis);
        }
        finally {
            this.endTrace();
        }
    }

    @Override
    public void runAsynchronous(FaultToleranceMethodContext.AsyncFuture asyncResult, Callable<Object> task) throws RejectedExecutionException {
        Runnable completionTask = () -> {
            if (!asyncResult.isCancelled() && !Thread.currentThread().isInterrupted()) {
                boolean returned = false;
                try {
                    this.trace("runAsynchronous");
                    if (this.shared.requestContext != null) {
                        this.shared.requestContext.activate();
                    }
                    Object res = task.call();
                    returned = true;
                    Future<?> futureResult = AsynchronousPolicy.toFuture(res);
                    if (!asyncResult.isCancelled()) {
                        if (!asyncResult.isDone()) {
                            asyncResult.complete(futureResult.get());
                        }
                    } else {
                        futureResult.cancel(true);
                    }
                }
                catch (Error | Exception ex) {
                    asyncResult.setExceptionThrown(!returned);
                    asyncResult.completeExceptionally(returned && ex instanceof ExecutionException ? ex.getCause() : ex);
                }
                finally {
                    if (this.shared.requestContext != null) {
                        this.shared.requestContext.deactivate();
                    }
                    this.endTrace();
                }
            }
        };
        this.shared.asyncExecution.submit(completionTask);
    }

    @Override
    public Future<?> runDelayed(long delayMillis, Runnable task) throws Exception {
        return this.shared.delayedExecution.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object fallbackHandle(Class<? extends FallbackHandler<?>> fallbackClass, Throwable ex) throws Exception {
        return ((FallbackHandler)CDI.current().select(fallbackClass, new Annotation[0]).get()).handle(new FaultToleranceExecutionContext(this.context.getMethod(), this.context.getParameters(), ex));
    }

    @Override
    public Object fallbackInvoke(Method fallbackMethod) throws Exception {
        try {
            fallbackMethod.setAccessible(true);
            return fallbackMethod.invoke(this.context.getTarget(), this.context.getParameters());
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw new FaultToleranceDefinitionException(e);
        }
    }

    @Override
    public void trace(String method) {
        this.shared.requestTracing.startSpan(new RequestTraceSpan(method), this.context);
    }

    @Override
    public void endTrace() {
        this.shared.requestTracing.endSpan();
    }

    public String toString() {
        return super.toString() + "[method=" + this.context.getMethod() + ", target=" + this.context.getTarget() + ", sharedState=" + this.shared + "]";
    }

    static final class FaultToleranceMethodState {
        final RequestContextController requestContext;
        final FaultToleranceRequestTracing requestTracing;
        final FaultToleranceMetrics metrics;
        final ExecutorService asyncExecution;
        final ScheduledExecutorService delayedExecution;
        final AtomicReference<CircuitBreakerState> circuitBreakerState = new AtomicReference();
        final AtomicReference<BlockingQueue<Thread>> concurrentExecutions = new AtomicReference();
        final AtomicInteger queuingOrRunningPopulation = new AtomicInteger();
        final AtomicInteger executingThreadCount = new AtomicInteger();
        final AtomicLong lastUsed = new AtomicLong(System.currentTimeMillis());

        FaultToleranceMethodState(RequestContextController requestContext, FaultToleranceRequestTracing requestTracing, FaultToleranceMetrics metrics, ExecutorService asyncExecution, ScheduledExecutorService delayedExecution) {
            this.requestContext = requestContext;
            this.requestTracing = requestTracing;
            this.metrics = metrics;
            this.asyncExecution = asyncExecution;
            this.delayedExecution = delayedExecution;
        }
    }
}

