/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerPrimaryKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.ejb.FinderException;

public class NonPersistentEJBTimerService
extends EJBTimerService {
    protected NonPersistentEJBTimerService() throws Exception {
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    protected boolean isNonpersistent(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt == null) {
            return false;
        }
        NonPersistentEJBTimerService.checkNonpersistentTimerValid(rt);
        return true;
    }

    @Override
    public int migrateTimers(String fromOwnerId) {
        throw new IllegalStateException("Non-persistent timers cannot be migrated");
    }

    @Override
    protected void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        if (!this.cancelNonPersistentTimer(timerId)) {
            NonPersistentEJBTimerService.checkNonpersistentTimerValid(null);
        }
    }

    @Override
    protected void cancelTimersByKey(long containerId, Object primaryKey) {
        Collection<TimerPrimaryKey> timerIds = this.getTimerIds(containerId, primaryKey);
        for (TimerPrimaryKey timerId : timerIds) {
            try {
                this.cancelTimer(timerId);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Cannot cancel non-persistent timer " + timerId, ex);
            }
        }
    }

    @Override
    protected Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return this._getNextTimeout(rt);
        }
        throw new FinderException("Timer does not exist");
    }

    @Override
    protected boolean isValidTimerForThisServer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        return true;
    }

    protected boolean cancelNonPersistentTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt == null) {
            return false;
        }
        NonPersistentEJBTimerService.checkNonpersistentTimerValid(rt);
        this.cancelTimerSynchronization(null, timerId, rt.getContainerId(), this.ownerIdOfThisServer_, false);
        return true;
    }

    private static void checkNonpersistentTimerValid(RuntimeTimerState st) throws FinderException {
        if (st == null || st.isCancelled() || st.isExpired()) {
            String id = st == null ? "" : st.getTimerId() + " ";
            throw new FinderException("Timer " + id + "is no longer active");
        }
    }

    private RuntimeTimerState getNonPersistentTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getNonPersistentTimerState(timerId);
    }

    @Override
    public Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsByThisServer() {
        return this.timerCache_.getNonPersistentActiveTimerIdsByThisServer();
    }

    protected RuntimeTimerState getNonPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null && rt.isCancelled()) {
            throw new FinderException("Non-persistent timer " + timerId + " does not exist");
        }
        return rt;
    }

    @Override
    protected EJBTimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = null;
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        NonPersistentEJBTimerService.checkNonpersistentTimerValid(rt);
        ts = rt.getTimerSchedule();
        return ts;
    }

    @Override
    protected boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        NonPersistentEJBTimerService.checkNonpersistentTimerValid(rt);
        return false;
    }

    @Override
    protected boolean timerExists(TimerPrimaryKey timerId) {
        boolean exists = false;
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null) {
            exists = rt.isActive();
        }
        return exists;
    }

    @Override
    protected Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        NonPersistentEJBTimerService.checkNonpersistentTimerValid(rt);
        return rt.getInfo();
    }

    @Override
    protected Collection<TimerPrimaryKey> getTimerIds(Collection<Long> containerIds) {
        HashSet<TimerPrimaryKey> timerIds = new HashSet<TimerPrimaryKey>();
        for (long containerId : containerIds) {
            timerIds.addAll(this.timerCache_.getNonPersistentActiveTimerIdsForContainer(containerId));
        }
        return timerIds;
    }

    @Override
    protected Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerPrimaryKey> timerIdsForTimedObject = new HashSet<TimerPrimaryKey>();
        timerIdsForTimedObject.addAll(this.timerCache_.getNonPersistentActiveTimerIdsForContainer(containerId));
        return timerIdsForTimedObject;
    }

    @Override
    protected void stopTimers(long containerId) {
        this.stopTimers(this.timerCache_.getNonPersistentTimerIdsForContainer(containerId));
    }

    @Override
    protected void resetEJBTimers(String target) {
    }

    @Override
    protected void resetLastExpiration(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
    }
}

