/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

public class SessionLock {
    private static final String BACKGROUND_LOCK = "background_lock";
    private static final String FOREGROUND_LOCK = "foreground_lock";
    private String _lockType = null;
    private int _foregroundRefCount = 0;
    private boolean _hasNonHttpLockOccurred = false;

    public String getLockType() {
        return this._lockType;
    }

    public void setLockType(String lockType) {
        this._lockType = lockType;
        if (lockType == null) {
            this._hasNonHttpLockOccurred = false;
        }
    }

    public int getForegroundRefCount() {
        return this._foregroundRefCount;
    }

    public void setForegroundRefCount(int foregroundRefCount) {
        this._foregroundRefCount = foregroundRefCount;
    }

    public void incrementForegroundRefCount() {
        ++this._foregroundRefCount;
    }

    public void decrementForegroundRefCount() {
        --this._foregroundRefCount;
    }

    public boolean isBackgroundLocked() {
        if (this._lockType == null) {
            return false;
        }
        return this._lockType.equals(BACKGROUND_LOCK);
    }

    public boolean isForegroundLocked() {
        if (this._lockType == null) {
            return false;
        }
        return this._lockType.equals(FOREGROUND_LOCK);
    }

    public boolean isLocked() {
        return this._lockType != null;
    }

    public boolean hasNonHttpLockOccurred() {
        return this._hasNonHttpLockOccurred;
    }

    public void unlock() {
        if (!this.isLocked()) {
            return;
        }
        if (this.isBackgroundLocked()) {
            this.setLockType(null);
            this.setForegroundRefCount(0);
            return;
        }
        if (this.isForegroundLocked()) {
            this.decrementForegroundRefCount();
            if (this._foregroundRefCount == 0) {
                this.setLockType(null);
            }
        }
    }

    public void unlockForeground() {
        if (!this.isLocked()) {
            return;
        }
        if (this.isForegroundLocked()) {
            this.decrementForegroundRefCount();
            if (this._foregroundRefCount == 0) {
                this.setLockType(null);
            }
        }
    }

    public void unlockForegroundCompletely() {
        if (!this.isLocked()) {
            return;
        }
        if (this.isForegroundLocked()) {
            this.setForegroundRefCount(0);
            this.setLockType(null);
        }
    }

    public void unlockBackground() {
        if (!this.isLocked()) {
            return;
        }
        if (this.isBackgroundLocked()) {
            this.setLockType(null);
            this.setForegroundRefCount(0);
        }
    }

    public synchronized boolean lockForeground() {
        return this.lockForeground(true);
    }

    public synchronized boolean lockForeground(boolean isHttp) {
        if (!isHttp) {
            this._hasNonHttpLockOccurred = true;
        }
        if (this.isBackgroundLocked()) {
            return false;
        }
        if (this.isForegroundLocked()) {
            this.incrementForegroundRefCount();
        } else {
            this.setForegroundRefCount(1);
        }
        this.setLockType(FOREGROUND_LOCK);
        return true;
    }

    public synchronized boolean lockBackground() {
        if (this.isForegroundLocked()) {
            return false;
        }
        this.setLockType(BACKGROUND_LOCK);
        this.setForegroundRefCount(0);
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("_lockType= ").append(this._lockType);
        sb.append("\nforegroundRefCount= ").append(this._foregroundRefCount);
        return sb.toString();
    }
}

