/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.logging.Level;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.glassfish.web.util.IntrospectionUtils;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    private String[] attributeNames;
    private String[] propertyNames;

    public SetPropertiesRule(Digester digester) {
        this();
    }

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String attributeName, String propertyName) {
        this.attributeNames = new String[1];
        this.attributeNames[0] = attributeName;
        this.propertyNames = new String[1];
        this.propertyNames[0] = propertyName;
    }

    public SetPropertiesRule(String[] attributeNames, String[] propertyNames) {
        this.attributeNames = new String[attributeNames.length];
        for (String this.attributeNames[i] : attributeNames) {
        }
        this.propertyNames = new String[propertyNames.length];
        for (String this.propertyNames[i] : propertyNames) {
        }
    }

    @Override
    public void begin(Attributes attributes) throws Exception {
        Object top = this.digester.peek();
        if (this.digester.log.isLoggable(Level.FINE)) {
            if (top != null) {
                this.digester.log.log(Level.FINE, "[SetPropertiesRule]'{'{0}'}' Set {1} properties", new Object[]{this.digester.match, top.getClass().getName()});
            } else {
                this.digester.log.log(Level.FINE, "[SetPropertiesRule]'{'{0}'}' Set NULL properties", this.digester.match);
            }
        }
        int attNamesLength = 0;
        if (this.attributeNames != null) {
            attNamesLength = this.attributeNames.length;
        }
        int propNamesLength = 0;
        if (this.propertyNames != null) {
            propNamesLength = this.propertyNames.length;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            if ("".equals(name)) {
                name = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            for (int n = 0; n < attNamesLength; ++n) {
                if (!name.equals(this.attributeNames[n])) continue;
                if (n < propNamesLength) {
                    name = this.propertyNames[n];
                    break;
                }
                name = null;
                break;
            }
            if (this.digester.log.isLoggable(Level.FINE)) {
                this.digester.log.log(Level.FINE, "[SetPropertiesRule]'{'{0}'}' Setting property ''{1}'' to ''{2}''", new Object[]{this.digester.match, name, value});
            }
            if (this.digester.isFakeAttribute(top, name) || IntrospectionUtils.setProperty((Object)top, (String)name, (String)value) || !this.digester.getRulesValidation()) continue;
            this.digester.log.log(Level.WARNING, "AS-WEB-CORE-00533", new Object[]{this.digester.match, name, value});
        }
    }

    public void addAlias(String attributeName, String propertyName) {
        if (this.attributeNames == null) {
            this.attributeNames = new String[1];
            this.attributeNames[0] = attributeName;
            this.propertyNames = new String[1];
            this.propertyNames[0] = propertyName;
        } else {
            int length = this.attributeNames.length;
            String[] tempAttributes = new String[length + 1];
            System.arraycopy(this.attributeNames, 0, tempAttributes, 0, length);
            tempAttributes[length] = attributeName;
            String[] tempProperties = new String[length + 1];
            for (int i = 0; i < length && i < this.propertyNames.length; ++i) {
                tempProperties[i] = this.propertyNames[i];
            }
            tempProperties[length] = propertyName;
            this.propertyNames = tempProperties;
            this.attributeNames = tempAttributes;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetPropertiesRule[");
        sb.append("]");
        return sb.toString();
    }
}

