/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherConstants;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.admin.launcher.GFLauncherNativeHelper;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.JDK;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class GFLauncher {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile(".* version \"([^\"\\-]+)(-.*)?\".*");
    private final List<String> commandLine = new ArrayList<String>();
    private final List<String> jvmOptionsList = new ArrayList<String>();
    private final GFLauncherInfo info;
    private Map<String, String> asenvProps;
    private JavaConfig javaConfig;
    private JvmOptions jvmOptions;
    private Profiler profiler;
    private Map<String, String> sysPropsFromXml;
    private String javaExe;
    private String classpath;
    private String adminFileRealmKeyFile;
    private boolean secureAdminEnabled;
    private List<String> debugOptions;
    private long startTime;
    private String logFilename;
    private LaunchType mode = LaunchType.normal;
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(GFLauncher.class);
    private boolean setupCalledByClients = false;
    private int exitValue = -1;
    private ProcessWhacker processWhacker;
    private Process process;
    private ProcessStreamDrainer psd;
    private boolean logFilenameWasFixed = false;
    private boolean needsAutoUpgrade = false;
    private boolean needsManualUpgrade = false;
    private int debugPort = -1;
    private boolean debugSuspend = false;

    public final GFLauncherInfo getInfo() {
        return this.info;
    }

    public final void launch() throws GFLauncherException {
        try {
            this.startTime = System.currentTimeMillis();
            if (!this.setupCalledByClients) {
                this.setup();
            }
            this.internalLaunch();
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(STRINGS.get("unknownError", t.getMessage()), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public final void relaunch() throws GFLauncherException {
        this.setupCalledByClients = false;
        this.launch();
    }

    public final void launchJVM(List<String> cmdsIn) throws GFLauncherException {
        try {
            this.setup();
            LinkedList<String> commands = new LinkedList<String>();
            commands.add(this.javaExe);
            for (String cmd : cmdsIn) {
                commands.add(cmd);
            }
            ProcessBuilder pb = new ProcessBuilder(commands);
            Process p = pb.start();
            ProcessStreamDrainer.drain("launchJVM", p);
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(STRINGS.get("unknownError", t.getMessage()), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public void setup() throws GFLauncherException, MiniXmlParserException {
        ASenvPropertyReader pr = this.isFakeLaunch() ? new ASenvPropertyReader(this.info.getInstallDir()) : new ASenvPropertyReader();
        this.asenvProps = pr.getProps();
        this.info.setup();
        this.setupLogLevels();
        MiniXmlParser parser = new MiniXmlParser(this.getInfo().getConfigFile(), this.getInfo().getInstanceName());
        String domainName = parser.getDomainName();
        if (GFLauncherUtils.ok(domainName)) {
            this.info.setDomainName(domainName);
        }
        this.info.setAdminAddresses(parser.getAdminAddresses());
        this.javaConfig = new JavaConfig(parser.getJavaConfig());
        String jhome = this.javaConfig.getJavaHome();
        if (GFLauncherUtils.ok(jhome) && !jhome.trim().equals("${com.sun.aas.javaRoot}")) {
            this.asenvProps.put("com.sun.aas.javaRoot", jhome);
        }
        this.setJavaExecutable();
        this.setupProfilerAndJvmOptions(parser);
        this.setupUpgradeSecurity();
        Map<String, String> realmprops = parser.getAdminRealmProperties();
        if (realmprops != null) {
            String classname = realmprops.get("classname");
            String keyfile = realmprops.get("file");
            if ("com.sun.enterprise.security.auth.realm.file.FileRealm".equals(classname) && keyfile != null) {
                this.adminFileRealmKeyFile = keyfile;
            }
        }
        this.secureAdminEnabled = parser.getSecureAdminEnabled();
        this.renameOsgiCache();
        this.setupMonitoring(parser);
        this.sysPropsFromXml = parser.getSystemProperties();
        this.asenvProps.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getPath());
        this.debugOptions = this.getDebug();
        this.parseDebug();
        parser.setupConfigDir(this.getInfo().getConfigDir(), this.getInfo().getInstallDir());
        this.setLogFilename(parser);
        this.resolveAllTokens();
        this.fixLogFilename();
        GFLauncherLogger.addLogFileHandler(this.logFilename);
        this.setClasspath();
        this.setCommandLine();
        this.setJvmOptions();
        this.logCommandLine();
        this.checkJDKVersion();
        this.needsAutoUpgrade = !parser.hasNetworkConfig();
        this.needsManualUpgrade = !parser.hasDefaultConfig();
        this.setupCalledByClients = true;
    }

    public String getAdminRealmKeyFile() {
        return this.adminFileRealmKeyFile;
    }

    public boolean isSecureAdminEnabled() {
        return this.secureAdminEnabled;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final Process getProcess() throws GFLauncherException {
        if (this.process == null) {
            throw new GFLauncherException("invalid_process");
        }
        return this.process;
    }

    public final ProcessStreamDrainer getProcessStreamDrainer() throws GFLauncherException {
        if (this.psd == null) {
            throw new GFLauncherException("invalid_psd");
        }
        return this.psd;
    }

    public String getLogFilename() throws GFLauncherException {
        if (!this.logFilenameWasFixed) {
            throw new GFLauncherException(STRINGS.get("internalError") + " call to getLogFilename() before it has been initialized");
        }
        return this.logFilename;
    }

    public final int getDebugPort() {
        return this.debugPort;
    }

    public final boolean isDebugSuspend() {
        return this.debugPort >= 0 && this.debugSuspend;
    }

    public final boolean needsAutoUpgrade() {
        return this.needsAutoUpgrade;
    }

    public final boolean needsManualUpgrade() {
        return this.needsManualUpgrade;
    }

    abstract void internalLaunch() throws GFLauncherException;

    private void parseDebug() {
        for (String opt : this.debugOptions) {
            if (!GFLauncher.isJdwpOption(opt)) continue;
            this.debugPort = GFLauncher.extractDebugPort(opt);
            this.debugSuspend = GFLauncher.extractDebugSuspend(opt);
        }
    }

    static boolean isJdwpOption(String option) {
        return option.startsWith("-Xrunjdwp:") || option.startsWith("-agentlib:jdwp");
    }

    static int extractDebugPort(String option) {
        Pattern portRegex = Pattern.compile(".*address=(?<port>\\d*).*");
        Matcher m = portRegex.matcher(option);
        if (!m.matches()) {
            return -1;
        }
        try {
            String addressGroup = m.group("port");
            return Integer.parseInt(addressGroup);
        }
        catch (NumberFormatException nfex) {
            return -1;
        }
    }

    static boolean extractDebugSuspend(String option) {
        Pattern suspendRegex = Pattern.compile(".*suspend=[yY](?:,.*|$)");
        Matcher m = suspendRegex.matcher(option);
        return m.matches();
    }

    private void setLogFilename(MiniXmlParser parser) {
        this.logFilename = this.info.isInstance() ? parser.getInstanceLogFilename() : parser.getLogFilename();
        if (this.logFilename == null) {
            this.logFilename = "logs/server.log";
        }
    }

    private void fixLogFilename() throws GFLauncherException {
        boolean wasCreated;
        File parent;
        File f;
        if (!GFLauncherUtils.ok(this.logFilename)) {
            this.logFilename = "logs/server.log";
        }
        if (!(f = new File(this.logFilename)).isAbsolute()) {
            f = new File(this.info.getInstanceRootDir(), this.logFilename);
        }
        if (!((f = SmartFile.sanitize(f)).exists() || (parent = f.getParentFile()).isDirectory() || (wasCreated = parent.mkdirs()))) {
            f = null;
        }
        this.logFilename = f == null ? null : f.getPath();
        this.logFilenameWasFixed = true;
    }

    void setMode(LaunchType mode) {
        this.mode = mode;
    }

    LaunchType getMode() {
        return this.mode;
    }

    boolean isFakeLaunch() {
        return this.mode == LaunchType.fake;
    }

    abstract List<File> getMainClasspath() throws GFLauncherException;

    abstract String getMainClass() throws GFLauncherException;

    GFLauncher(GFLauncherInfo info) {
        this.info = info;
    }

    final Map<String, String> getEnvProps() {
        return this.asenvProps;
    }

    public final List<String> getCommandLine() {
        return this.commandLine;
    }

    final long getStartTime() {
        return this.startTime;
    }

    void launchInstance() throws GFLauncherException, MiniXmlParserException {
        List<String> cmds;
        if (this.isFakeLaunch()) {
            return;
        }
        if (OS.isDarwin() && GFLauncher.useLaunchCtl(System.getProperty("os.version")) && !this.getInfo().isVerboseOrWatchdog()) {
            cmds = new ArrayList<String>();
            cmds.add("nohup");
            cmds.addAll(this.getCommandLine());
        } else {
            cmds = this.getCommandLine();
        }
        ProcessBuilder pb = new ProcessBuilder(cmds);
        try {
            File newDir = this.getInfo().getConfigDir();
            pb.directory(newDir);
        }
        catch (Exception newDir) {
            // empty catch block
        }
        try {
            this.closeStandardStreamsMaybe();
            this.process = pb.start();
            String name = this.getInfo().getDomainName();
            this.psd = this.getInfo().isVerbose() ? ProcessStreamDrainer.redirect(name, this.process) : (this.getInfo().isWatchdog() ? ProcessStreamDrainer.dispose(name, this.process) : ProcessStreamDrainer.save(name, this.process));
            this.writeSecurityTokens(this.process);
        }
        catch (Exception e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
        if (this.getInfo().isVerboseOrWatchdog()) {
            this.wait(this.process);
        }
    }

    private static boolean useLaunchCtl(String osversion) {
        int major = 0;
        int minor = 0;
        if (osversion == null || osversion.isEmpty()) {
            return false;
        }
        String[] split = osversion.split("[\\._\\-]+");
        try {
            if (split.length > 0 && split[0].length() > 0) {
                major = Integer.parseInt(split[0]);
            }
            if (split.length > 1 && split[1].length() > 0) {
                minor = Integer.parseInt(split[1]);
            }
            return major <= 9 || major <= 10 && minor < 10;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void writeSecurityTokens(Process sp) throws GFLauncherException, IOException {
        this.handleDeadProcess();
        OutputStream os = sp.getOutputStream();
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(os);
            bw = new BufferedWriter(osw);
            for (String token : this.info.securityTokens) {
                bw.write(token);
                bw.newLine();
                bw.flush();
            }
        }
        catch (IOException e) {
            this.handleDeadProcess();
            throw e;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (osw != null) {
                osw.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                this.handleDeadProcess();
            }
        }
    }

    private void handleDeadProcess() throws GFLauncherException {
        String trace = this.getDeadProcessTrace(this.process);
        if (trace != null) {
            throw new GFLauncherException(trace);
        }
    }

    private String getDeadProcessTrace(Process sp) throws GFLauncherException {
        try {
            int ev = sp.exitValue();
            ProcessStreamDrainer psd1 = this.getProcessStreamDrainer();
            String output = psd1.getOutErrString();
            return STRINGS.get("server_process_died", ev, output);
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    void setCommandLine() throws GFLauncherException {
        List<String> cmdLine = this.getCommandLine();
        cmdLine.clear();
        this.addIgnoreNull(cmdLine, this.javaExe);
        this.addIgnoreNull(cmdLine, "-cp");
        this.addIgnoreNull(cmdLine, this.getClasspath());
        this.addIgnoreNull(cmdLine, this.debugOptions);
        String CLIStartTime = System.getProperty("WALL_CLOCK_START");
        if (CLIStartTime != null && CLIStartTime.length() > 0) {
            cmdLine.add("-DWALL_CLOCK_START=" + CLIStartTime);
        }
        if (this.jvmOptions != null) {
            this.addIgnoreNull(cmdLine, this.jvmOptions.toStringArray());
        }
        GFLauncherNativeHelper nativeHelper = new GFLauncherNativeHelper(this.info, this.javaConfig, this.jvmOptions, this.profiler);
        this.addIgnoreNull(cmdLine, nativeHelper.getCommands());
        this.addIgnoreNull(cmdLine, this.getMainClass());
        try {
            this.addIgnoreNull(cmdLine, this.getInfo().getArgsAsList());
        }
        catch (GFLauncherException gfle) {
            throw gfle;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setJvmOptions() {
        List<String> jvmOpts = this.getJvmOptions();
        jvmOpts.clear();
        if (this.jvmOptions != null) {
            this.addIgnoreNull(jvmOpts, this.jvmOptions.toStringArray());
        }
    }

    public final List<String> getJvmOptions() {
        return this.jvmOptionsList;
    }

    private void addIgnoreNull(List<String> list, String s) {
        if (GFLauncherUtils.ok(s)) {
            list.add(s);
        }
    }

    private void addIgnoreNull(List<String> list, Collection<String> ss) {
        if (ss != null && !ss.isEmpty()) {
            list.addAll(ss);
        }
    }

    private void wait(Process p) throws GFLauncherException {
        try {
            this.setShutdownHook(p);
            p.waitFor();
            this.exitValue = p.exitValue();
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    private void setShutdownHook(Process p) {
        if (this.processWhacker == null) {
            Runtime runtime = Runtime.getRuntime();
            String msg = STRINGS.get("serverStopped", this.info.getType());
            this.processWhacker = new ProcessWhacker(p, msg);
            runtime.addShutdownHook(new Thread(this.processWhacker));
        } else {
            this.processWhacker.setProcess(p);
        }
    }

    private void resolveAllTokens() {
        HashMap<String, String> all = new HashMap<String, String>();
        Map<String, String> envProps = System.getenv();
        Map<String, String> sysProps = CollectionUtils.propertiesToStringMap(System.getProperties());
        all.putAll(envProps);
        all.putAll(this.asenvProps);
        all.putAll(sysProps);
        all.put("com.sun.aas.instanceName", this.getInfo().getInstanceName());
        all.putAll(this.sysPropsFromXml);
        all.putAll(this.jvmOptions.getCombinedMap());
        all.putAll(this.profiler.getConfig());
        TokenResolver resolver = new TokenResolver(all);
        resolver.resolve(this.jvmOptions.xProps);
        resolver.resolve(this.jvmOptions.xxProps);
        resolver.resolve(this.jvmOptions.plainProps);
        resolver.resolve(this.jvmOptions.sysProps);
        resolver.resolve(this.javaConfig.getMap());
        resolver.resolve(this.profiler.getConfig());
        resolver.resolve(this.debugOptions);
        this.logFilename = resolver.resolve(this.logFilename);
        this.adminFileRealmKeyFile = resolver.resolve(this.adminFileRealmKeyFile);
    }

    private void setJavaExecutable() throws GFLauncherException {
        if (this.setJavaExecutableIfValid(this.javaConfig.getJavaHome())) {
            return;
        }
        if (!this.setJavaExecutableIfValid(this.asenvProps.get("com.sun.aas.javaRoot"))) {
            throw new GFLauncherException("nojvm");
        }
    }

    void setClasspath() throws GFLauncherException {
        List<File> mainCP = this.getMainClasspath();
        List<File> envCP = this.javaConfig.getEnvClasspath();
        List<File> sysCP = this.javaConfig.getSystemClasspath();
        List<File> prefixCP = this.javaConfig.getPrefixClasspath();
        List<File> suffixCP = this.javaConfig.getSuffixClasspath();
        List<File> profilerCP = this.profiler.getClasspath();
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(prefixCP);
        all.addAll(profilerCP);
        all.addAll(mainCP);
        all.addAll(sysCP);
        all.addAll(envCP);
        all.addAll(suffixCP);
        this.setClasspath(GFLauncherUtils.fileListToPathString(all));
    }

    boolean setJavaExecutableIfValid(String filename) {
        if (!GFLauncherUtils.ok(filename)) {
            return false;
        }
        File f = new File(filename);
        if (!f.isDirectory()) {
            return false;
        }
        f = GFLauncherUtils.isWindows() ? new File(f, "bin/java.exe") : new File(f, "bin/java");
        if (f.exists()) {
            this.javaExe = SmartFile.sanitize(f).getPath();
            return true;
        }
        return false;
    }

    private List<String> getDebug() {
        if (this.info.isDebug() || this.javaConfig.isDebugEnabled()) {
            return this.javaConfig.getDebugOptions();
        }
        return Collections.emptyList();
    }

    private void setupProfilerAndJvmOptions(MiniXmlParser parser) throws MiniXmlParserException, GFLauncherException {
        this.profiler = new Profiler(parser.getProfilerConfig(), parser.getProfilerJvmOptions(), parser.getProfilerSystemProperties());
        Optional<JDK.Version> jdkVersion = this.getConfiguredJdkVersion(this.javaExe);
        List<String> rawJvmOptions = parser.getJvmOptions().stream().filter(fullOption -> JDK.isCorrectJDK(jdkVersion, fullOption.vendorOrVM, fullOption.minVersion, fullOption.maxVersion)).map(option -> option.option).collect(Collectors.toList());
        rawJvmOptions.addAll(this.getSpecialSystemProperties());
        if (this.profiler.isEnabled()) {
            rawJvmOptions.addAll(this.profiler.getJvmOptions());
        }
        this.jvmOptions = new JvmOptions(rawJvmOptions);
        if (this.info.isDropInterruptedCommands()) {
            this.jvmOptions.sysProps.put("org.glassfish.job-manager.drop-interrupted-commands", Boolean.TRUE.toString());
        }
        this.addDefaultJvmOptions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<JDK.Version> getConfiguredJdkVersion(String javaExePath) throws GFLauncherException {
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(javaExePath + " -version");
            p.waitFor();
            try (BufferedReader b = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String line;
                Matcher m;
                do {
                    if ((line = b.readLine()) == null) return Optional.empty();
                } while (!(m = JAVA_VERSION_PATTERN.matcher(line)).matches());
                Optional<JDK.Version> optional = Optional.ofNullable(JDK.getVersion(m.group(1)));
                return optional;
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new GFLauncherException("nojvm");
        }
    }

    private void addDefaultJvmOptions() {
        if (!this.jvmOptions.getCombinedMap().containsKey("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER")) {
            this.jvmOptions.sysProps.put("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
            GFLauncherLogger.fine("PAYARA-GFLAUNCHER-00001", "org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        }
    }

    private void setupUpgradeSecurity() throws GFLauncherException {
        if (this.info.isUpgrade() && this.jvmOptions.sysProps.containsKey("java.security.manager")) {
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00004", new Object[0]);
            File source = new File(new File(new File(this.info.installDir, "lib"), "templates"), "server.policy");
            File target = new File(this.info.getConfigDir(), "server.policy");
            try {
                FileUtils.copyFile(source, target);
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause() == null ? ioe : ioe.getCause();
                throw new GFLauncherException(STRINGS.get("COPY_SERVER_POLICY_error", cause.getMessage()));
            }
        }
    }

    private void renameOsgiCache() throws GFLauncherException {
        if (this.info.isUpgrade()) {
            File osgiCacheDir = new File(this.info.getDomainRootDir(), "osgi-cache");
            File backupOsgiCacheDir = new File(this.info.getDomainRootDir(), "osgi-cache-" + System.currentTimeMillis());
            if (osgiCacheDir.exists() && !backupOsgiCacheDir.exists()) {
                if (!FileUtils.renameFile(osgiCacheDir, backupOsgiCacheDir)) {
                    throw new GFLauncherException(STRINGS.get("rename_osgi_cache_failed", osgiCacheDir, backupOsgiCacheDir));
                }
                GFLauncherLogger.fine("rename_osgi_cache_succeeded", osgiCacheDir, backupOsgiCacheDir);
            }
        }
    }

    private void setupMonitoring(MiniXmlParser parser) throws GFLauncherException {
        if (!parser.isMonitoringEnabled()) {
            return;
        }
        Set<String> plainKeys = this.jvmOptions.plainProps.keySet();
        for (String key : plainKeys) {
            if (!key.startsWith("javaagent:") || !(key = key.replace('\\', '/')).contains("flashlight-agent.jar")) continue;
            return;
        }
        try {
            this.jvmOptions.plainProps.put(this.getMonitoringAgentJvmOptionString(), null);
        }
        catch (GFLauncherException gFLauncherException) {
            // empty catch block
        }
    }

    private String getMonitoringAgentJvmOptionString() throws GFLauncherException {
        File libMonDir = new File(this.getInfo().getInstallDir(), "lib/monitor");
        File flashlightJarFile = new File(libMonDir, "flashlight-agent.jar");
        if (flashlightJarFile.isFile()) {
            return "javaagent:" + GFLauncher.getCleanPath(flashlightJarFile);
        }
        String msg = STRINGS.get("no_flashlight_agent", flashlightJarFile);
        GFLauncherLogger.warning("NCLS-GFLAUNCHER-00003", flashlightJarFile);
        throw new GFLauncherException(msg);
    }

    private static String getCleanPath(File f) {
        return SmartFile.sanitize(f).getPath().replace('\\', '/');
    }

    private List<String> getSpecialSystemProperties() throws GFLauncherException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.aas.installRoot", this.getInfo().getInstallDir().getAbsolutePath());
        props.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getAbsolutePath());
        return this.propsToJvmOptions(props);
    }

    void logCommandLine() {
        StringBuilder sb = new StringBuilder();
        if (!this.isFakeLaunch()) {
            List<String> cmdLine = this.getCommandLine();
            for (String s : cmdLine) {
                sb.append(GFLauncherConstants.NEWLINE);
                sb.append(s);
            }
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00005", sb.toString());
        }
    }

    private void checkJDKVersion() {
        if (!JDK.isRunningLTSJDK()) {
            GFLauncherLogger.warning("You are running the product on an unsupported JDK version and might see unexpected results or exceptions.", new Object[0]);
        }
    }

    String getClasspath() {
        return this.classpath;
    }

    void setClasspath(String s) {
        this.classpath = s;
    }

    private List<String> propsToJvmOptions(Map<String, String> map) {
        ArrayList<String> ss = new ArrayList<String>();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            String jvm = "-D" + name;
            if (value != null) {
                jvm = jvm + "=" + value;
            }
            ss.add(jvm);
        }
        return ss;
    }

    private void setupLogLevels() {
        if (this.info.isVerbose()) {
            GFLauncherLogger.setConsoleLevel(Level.INFO);
        } else {
            GFLauncherLogger.setConsoleLevel(Level.WARNING);
        }
    }

    private void closeStandardStreamsMaybe() {
        if (System.console() == null && OS.isWindows() && !this.info.isVerboseOrWatchdog()) {
            String sname = this.info.isDomain() ? this.info.getDomainName() : this.info.getInstanceName();
            System.out.println(STRINGS.get("ssh", sname));
            try {
                System.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.err.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ProcessWhacker
    implements Runnable {
        private final String message;
        private Process process;

        ProcessWhacker(Process p, String msg) {
            this.message = msg;
            this.process = p;
        }

        void setProcess(Process p) {
            this.process = p;
        }

        @Override
        public void run() {
            System.out.println(this.message);
            this.process.destroy();
        }
    }

    static enum LaunchType {
        normal,
        debug,
        trace,
        fake;

    }
}

