/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.util;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import java.sql.Driver;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.LoggerFactory;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class JdbcResourcesUtil {
    private static volatile JdbcResourcesUtil jdbcResourcesUtil;
    private static Logger _logger;
    private ConnectorRuntime runtime;

    private JdbcResourcesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JdbcResourcesUtil createInstance() {
        if (jdbcResourcesUtil != null) return jdbcResourcesUtil;
        Class<JdbcResourcesUtil> clazz = JdbcResourcesUtil.class;
        synchronized (JdbcResourcesUtil.class) {
            if (jdbcResourcesUtil != null) return jdbcResourcesUtil;
            jdbcResourcesUtil = new JdbcResourcesUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jdbcResourcesUtil;
        }
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorRuntime.getRuntime();
        }
        return this.runtime;
    }

    public static <T> Resource getResourceByName(Resources resources, Class<T> type, String name) {
        return resources.getResourceByName(type, name);
    }

    public static Collection<BindableResource> getResourcesOfPool(Resources resources, String connectionPoolName) {
        HashSet<BindableResource> resourcesReferringPool = new HashSet<BindableResource>();
        ResourcePool pool = (ResourcePool)JdbcResourcesUtil.getResourceByName(resources, ResourcePool.class, connectionPoolName);
        if (pool != null) {
            Collection bindableResources = resources.getResources(BindableResource.class);
            for (BindableResource resource : bindableResources) {
                if (!JdbcResource.class.isAssignableFrom(resource.getClass()) || !((JdbcResource)resource).getPoolName().equals(connectionPoolName)) continue;
                resourcesReferringPool.add(resource);
            }
        }
        return resourcesReferringPool;
    }

    public String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        Class clz = null;
        if (pool.getDatasourceClassname() != null && !pool.getDatasourceClassname().isEmpty()) {
            try {
                clz = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                _logger.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (pool.getDriverClassname() != null && !pool.getDriverClassname().isEmpty()) {
            try {
                clz = ClassLoadingUtility.loadClass(pool.getDriverClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                _logger.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (clz != null) {
            if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(clz)) {
                return "__xa_jdbc_ra";
            }
            if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(clz)) {
                return "__cp_jdbc_ra";
            }
            if ("java.sql.Driver".equals(pool.getResType()) && Driver.class.isAssignableFrom(clz)) {
                return "__dm_jdbc_ra";
            }
            if ("javax.sql.DataSource".equals(pool.getResType()) && DataSource.class.isAssignableFrom(clz)) {
                return dsRAName;
            }
        }
        Object[] params = new Object[]{dsRAName, pool.getName()};
        _logger.log(Level.WARNING, "using.default.ds", params);
        return dsRAName;
    }

    public JdbcConnectionPool getJdbcConnectionPoolOfResource(ResourceInfo resourceInfo) {
        JdbcResource resource = null;
        JdbcConnectionPool pool = null;
        Resources resources = this.getResources(resourceInfo);
        if (resources != null && (resource = (JdbcResource)ConnectorsUtil.getResourceByName((Resources)resources, JdbcResource.class, (String)resourceInfo.getName())) != null) {
            pool = (JdbcConnectionPool)ConnectorsUtil.getResourceByName((Resources)resources, JdbcConnectionPool.class, (String)resource.getPoolName());
        }
        return pool;
    }

    private Resources getResources(ResourceInfo resourceInfo) {
        return this.getRuntime().getResources(resourceInfo);
    }

    public boolean isJdbcPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection jdbcResources = this.getRuntime().getResources(poolInfo).getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
            if (!resource.getPoolName().equalsIgnoreCase(poolInfo.getName()) || !ResourcesUtil.createInstance().isReferenced(resourceInfo) || !ResourcesUtil.createInstance().isEnabled((BindableResource)resource)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("pool " + poolInfo + "resource " + resourceInfo + " referred " + ResourcesUtil.createInstance().isReferenced(resourceInfo));
                _logger.fine("JDBC resource " + resource.getJndiName() + "refers " + poolInfo + "in this server instance and is enabled");
            }
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("No JDBC resource refers [ " + poolInfo + " ] in this server instance");
        }
        return false;
    }

    static {
        _logger = LoggerFactory.getLogger(JdbcResourcesUtil.class);
    }
}

