/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.runtime.common;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageDescriptor
extends RuntimeDescriptor {
    private static final long serialVersionUID = 6097863237384161130L;
    public static final String JAVA_METHOD = "JavaMethod";
    public static final String OPERATION_NAME = "OperationName";
    private static final String ALL_METHODS = "*";
    private String operationName;
    private MethodDescriptor methodDescriptor;
    private List<MethodDescriptor> convertedmethodDescriptors = new ArrayList<MethodDescriptor>();
    private ServiceRefPortInfo portInfo;
    private WebServiceEndpoint webServiceEndpoint;
    private BundleDescriptor bundleDescriptor;
    private boolean isConverted;

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public void setServiceRefPortInfo(ServiceRefPortInfo portInfo) {
        this.portInfo = portInfo;
    }

    public ServiceRefPortInfo getServiceRefPortInfo() {
        return this.portInfo;
    }

    public void setWebServiceEndpoint(WebServiceEndpoint endPoint) {
        this.webServiceEndpoint = endPoint;
    }

    public WebServiceEndpoint getWebServiceEndpoint() {
        return this.webServiceEndpoint;
    }

    public void setBundleDescriptor(BundleDescriptor bundleDesc) {
        this.bundleDescriptor = bundleDesc;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public List<MethodDescriptor> getAllDefinedMethodsInMessage() {
        if (!this.isConverted) {
            this.doStyleConversion();
        }
        return this.convertedmethodDescriptors;
    }

    private void doStyleConversion() {
        if (this.operationName == null && this.methodDescriptor == null) {
            this.convertedmethodDescriptors = this.getAllSEIMethodsOf(ALL_METHODS);
        } else if (this.methodDescriptor != null) {
            if (this.methodDescriptor.getName() != null && this.methodDescriptor.getParameterClassNames() != null) {
                this.convertedmethodDescriptors.add(this.methodDescriptor);
            } else if (this.methodDescriptor.getName() != null && this.methodDescriptor.getParameterClassNames() == null) {
                this.convertedmethodDescriptors = this.getAllSEIMethodsOf(this.methodDescriptor.getName());
            }
        }
        this.isConverted = true;
    }

    private List<MethodDescriptor> getAllSEIMethodsOf(String methodName) {
        String serviceInterfaceName = null;
        ArrayList<MethodDescriptor> allMethodsInSEI = new ArrayList<MethodDescriptor>();
        if (this.webServiceEndpoint != null) {
            serviceInterfaceName = this.webServiceEndpoint.getServiceEndpointInterface();
        } else if (this.portInfo != null) {
            serviceInterfaceName = this.portInfo.getServiceEndpointInterface();
        }
        if (serviceInterfaceName == null) {
            return allMethodsInSEI;
        }
        ClassLoader classLoader = null;
        if (this.bundleDescriptor != null) {
            classLoader = this.bundleDescriptor.getClassLoader();
        }
        if (classLoader == null) {
            return allMethodsInSEI;
        }
        try {
            for (Method method : classLoader.loadClass(serviceInterfaceName).getMethods()) {
                if (methodName.equals(ALL_METHODS)) {
                    allMethodsInSEI.add(new MethodDescriptor(method));
                    continue;
                }
                if (!methodName.equals(method.getName())) continue;
                allMethodsInSEI.add(new MethodDescriptor(method));
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error occurred", e);
        }
        return allMethodsInSEI;
    }
}

