/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPGroupSummary;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.exception.CannotCreateRaftGroupException;
import com.hazelcast.cp.internal.operation.ChangeRaftGroupMembershipOp;
import com.hazelcast.cp.internal.operation.DefaultRaftReplicateOp;
import com.hazelcast.cp.internal.operation.DestroyRaftGroupOp;
import com.hazelcast.cp.internal.operation.RaftQueryOp;
import com.hazelcast.cp.internal.operation.unsafe.AbstractUnsafeRaftOp;
import com.hazelcast.cp.internal.operation.unsafe.UnsafeRaftQueryOp;
import com.hazelcast.cp.internal.operation.unsafe.UnsafeRaftReplicateOp;
import com.hazelcast.cp.internal.raft.MembershipChangeMode;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raftop.metadata.CreateRaftGroupOp;
import com.hazelcast.cp.internal.raftop.metadata.CreateRaftNodeOp;
import com.hazelcast.cp.internal.raftop.metadata.GetActiveCPMembersOp;
import com.hazelcast.cp.internal.raftop.metadata.GetRaftGroupIdsOp;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.util.RandomPicker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.RaftInvocation;
import com.hazelcast.spi.impl.operationservice.impl.RaftInvocationContext;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class RaftInvocationManager {
    private static final int RANDOM_RAFT_GROUP_INDEX_RANGE = 10000;
    private final NodeEngineImpl nodeEngine;
    private final OperationServiceImpl operationService;
    private final RaftService raftService;
    private final ILogger logger;
    private final RaftInvocationContext raftInvocationContext;
    private final long operationCallTimeout;
    private final int invocationMaxRetryCount;
    private final long invocationRetryPauseMillis;
    private final boolean cpSubsystemEnabled;

    RaftInvocationManager(NodeEngine nodeEngine, RaftService raftService) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        this.logger = nodeEngine.getLogger(this.getClass());
        this.raftService = raftService;
        this.raftInvocationContext = new RaftInvocationContext(this.logger, raftService);
        this.invocationMaxRetryCount = nodeEngine.getProperties().getInteger(ClusterProperty.INVOCATION_MAX_RETRY_COUNT);
        this.invocationRetryPauseMillis = nodeEngine.getProperties().getMillis(ClusterProperty.INVOCATION_RETRY_PAUSE);
        this.operationCallTimeout = nodeEngine.getProperties().getMillis(ClusterProperty.OPERATION_CALL_TIMEOUT_MILLIS);
        this.cpSubsystemEnabled = raftService.isCpSubsystemEnabled();
    }

    void reset() {
        this.raftInvocationContext.reset();
    }

    public InternalCompletableFuture<RaftGroupId> createRaftGroup(String groupName) {
        return this.createRaftGroup(groupName, this.raftService.getConfig().getGroupSize());
    }

    public InternalCompletableFuture<RaftGroupId> createRaftGroup(String groupName, int groupSize) {
        InternalCompletableFuture<RaftGroupId> completedFuture = this.completeExceptionallyIfCPSubsystemNotAvailable();
        if (completedFuture != null) {
            return completedFuture;
        }
        InternalCompletableFuture<RaftGroupId> resultFuture = new InternalCompletableFuture<RaftGroupId>();
        this.invokeGetMembersToCreateRaftGroup(groupName, groupSize, resultFuture);
        return resultFuture;
    }

    private <V> InternalCompletableFuture<V> completeExceptionallyIfCPSubsystemNotAvailable() {
        if (!this.cpSubsystemEnabled) {
            InternalCompletableFuture future = new InternalCompletableFuture();
            future.completeExceptionally(new HazelcastException("CP Subsystem is not enabled!"));
            return future;
        }
        return null;
    }

    private void invokeGetMembersToCreateRaftGroup(String groupName, int groupSize, InternalCompletableFuture<RaftGroupId> resultFuture) {
        RaftGroupId metadataGroupId = this.raftService.getMetadataGroupId();
        InternalCompletableFuture f1 = this.query(metadataGroupId, new GetActiveCPMembersOp(), QueryPolicy.LINEARIZABLE);
        InternalCompletableFuture f2 = this.query(metadataGroupId, new GetRaftGroupIdsOp(), QueryPolicy.LINEARIZABLE);
        ((CompletableFuture)f1.thenCombineAsync((CompletionStage)f2, (cpMembers, groupIds) -> {
            if (cpMembers.size() < groupSize) {
                IllegalArgumentException e = new IllegalArgumentException("There are not enough active CP members to create CP group " + groupName + ". Active CP members: " + cpMembers.size() + ", Requested CP group size: " + groupSize);
                resultFuture.completeExceptionally(e);
                return null;
            }
            long groupIndex = this.generateRandomGroupIndex((Collection<RaftGroupId>)groupIds);
            List<RaftEndpoint> groupEndpoints = this.generateRandomGroupMembers((List<CPMemberInfo>)cpMembers, groupSize);
            this.invokeCreateRaftGroup(groupName, groupSize, groupIndex, groupEndpoints, resultFuture);
            return null;
        })).exceptionally(t -> {
            resultFuture.completeExceptionally((Throwable)t);
            return null;
        });
    }

    private long generateRandomGroupIndex(Collection<RaftGroupId> groupIds) {
        long groupIndex = RandomPicker.getInt(10000);
        if (groupIds.size() > 0) {
            groupIndex += groupIds.stream().mapToLong(RaftGroupId::getId).max().getAsLong();
        }
        return groupIndex;
    }

    private List<RaftEndpoint> generateRandomGroupMembers(List<CPMemberInfo> cpMembers, int groupSize) {
        cpMembers = new ArrayList<CPMemberInfo>(cpMembers);
        Collections.shuffle(cpMembers);
        return cpMembers.stream().sorted(new CPMemberReachabilityComparator()).limit(groupSize).map(CPMemberInfo::toRaftEndpoint).collect(Collectors.toList());
    }

    private void invokeCreateRaftGroup(String groupName, int groupSize, long groupIndex, List<RaftEndpoint> members, InternalCompletableFuture<RaftGroupId> resultFuture) {
        InternalCompletableFuture f = this.invoke(this.raftService.getMetadataGroupId(), new CreateRaftGroupOp(groupName, members, groupIndex));
        f.whenCompleteAsync((group, t) -> {
            if (t == null) {
                resultFuture.complete((RaftGroupId)group.id());
                this.triggerRaftNodeCreation((CPGroupSummary)group);
            } else {
                if (t instanceof CannotCreateRaftGroupException) {
                    this.logger.fine("Could not create CP group: " + groupName + " with members: " + members + " and group index: " + groupIndex, t.getCause());
                    this.invokeGetMembersToCreateRaftGroup(groupName, groupSize, resultFuture);
                    return;
                }
                resultFuture.completeExceptionally((Throwable)t);
            }
        });
    }

    void triggerRaftNodeCreation(CPGroupSummary group) {
        for (CPMember groupMember : group.members()) {
            if (groupMember.equals(this.raftService.getLocalCPMember())) {
                ExecutionService executionService = this.nodeEngine.getExecutionService();
                executionService.execute("hz:cpSubsystem", () -> this.raftService.createRaftNode(group.id(), group.initialMembers()));
                continue;
            }
            CreateRaftNodeOp op = new CreateRaftNodeOp(group.id(), group.initialMembers());
            OperationServiceImpl operationService = this.nodeEngine.getOperationService();
            operationService.send(op, groupMember.getAddress());
        }
    }

    <T> InternalCompletableFuture<T> changeMembership(CPGroupId groupId, long membersCommitIndex, RaftEndpoint member, MembershipChangeMode membershipChangeMode) {
        InternalCompletableFuture completedFuture = this.completeExceptionallyIfCPSubsystemNotAvailable();
        if (completedFuture != null) {
            return completedFuture;
        }
        ChangeRaftGroupMembershipOp operation = new ChangeRaftGroupMembershipOp(groupId, membersCommitIndex, member, membershipChangeMode);
        RaftInvocation invocation = new RaftInvocation(this.operationService.getInvocationContext(), this.raftInvocationContext, groupId, operation, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, this.operationCallTimeout);
        return invocation.invoke();
    }

    public <T> InternalCompletableFuture<T> invoke(CPGroupId groupId, RaftOp raftOp) {
        return this.invoke(groupId, raftOp, true);
    }

    public <T> InternalCompletableFuture<T> invoke(CPGroupId groupId, RaftOp raftOp, boolean deserializeResponse) {
        if (this.cpSubsystemEnabled) {
            DefaultRaftReplicateOp operation = new DefaultRaftReplicateOp(groupId, raftOp);
            RaftInvocation invocation = new RaftInvocation(this.operationService.getInvocationContext(), this.raftInvocationContext, groupId, operation, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, this.operationCallTimeout, deserializeResponse);
            return invocation.invoke();
        }
        return this.invokeOnPartition(new UnsafeRaftReplicateOp(groupId, raftOp), deserializeResponse);
    }

    public <T> InternalCompletableFuture<T> invokeOnPartition(AbstractUnsafeRaftOp operation) {
        return this.invokeOnPartition(operation, true);
    }

    public <T> InternalCompletableFuture<T> invokeOnPartition(AbstractUnsafeRaftOp operation, boolean deserializeResponse) {
        int partitionId = this.raftService.getCPGroupPartitionId(operation.getGroupId());
        return this.nodeEngine.getOperationService().createInvocationBuilder(operation.getServiceName(), (Operation)operation, partitionId).setCallTimeout(this.operationCallTimeout).setTryCount(this.invocationMaxRetryCount).setTryPauseMillis(this.invocationRetryPauseMillis).setResultDeserialized(deserializeResponse).invoke();
    }

    public <T> InternalCompletableFuture<T> query(CPGroupId groupId, RaftOp raftOp, QueryPolicy queryPolicy) {
        return this.query(groupId, raftOp, queryPolicy, true);
    }

    public <T> InternalCompletableFuture<T> query(CPGroupId groupId, RaftOp raftOp, QueryPolicy queryPolicy, boolean deserializeResponse) {
        if (this.cpSubsystemEnabled) {
            RaftQueryOp operation = new RaftQueryOp(groupId, raftOp, queryPolicy);
            RaftInvocation invocation = new RaftInvocation(this.operationService.getInvocationContext(), this.raftInvocationContext, groupId, operation, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, this.operationCallTimeout, deserializeResponse);
            return invocation.invoke();
        }
        return this.invokeOnPartition(new UnsafeRaftQueryOp(groupId, raftOp), deserializeResponse);
    }

    public <T> InternalCompletableFuture<T> queryLocally(CPGroupId groupId, RaftOp raftOp, QueryPolicy queryPolicy) {
        Operation operation = this.cpSubsystemEnabled ? new RaftQueryOp(groupId, raftOp, queryPolicy) : new UnsafeRaftQueryOp(groupId, raftOp);
        operation.setPartitionId(this.raftService.getCPGroupPartitionId(groupId));
        return this.nodeEngine.getOperationService().invokeOnTarget("hz:core:raft", operation, this.nodeEngine.getThisAddress());
    }

    public InternalCompletableFuture<Object> destroy(CPGroupId groupId) {
        InternalCompletableFuture<Object> completedFuture = this.completeExceptionallyIfCPSubsystemNotAvailable();
        if (completedFuture != null) {
            return completedFuture;
        }
        DestroyRaftGroupOp operation = new DestroyRaftGroupOp(groupId);
        RaftInvocation invocation = new RaftInvocation(this.operationService.getInvocationContext(), this.raftInvocationContext, groupId, operation, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, this.operationCallTimeout);
        return invocation.invoke();
    }

    public RaftInvocationContext getRaftInvocationContext() {
        return this.raftInvocationContext;
    }

    CPMember getCPMember(RaftEndpoint endpoint) {
        return endpoint != null ? this.raftInvocationContext.getCPMember(endpoint.getUuid()) : null;
    }

    private class CPMemberReachabilityComparator
    implements Comparator<CPMemberInfo> {
        final ClusterService clusterService;

        private CPMemberReachabilityComparator() {
            this.clusterService = RaftInvocationManager.this.nodeEngine.getClusterService();
        }

        @Override
        public int compare(CPMemberInfo o1, CPMemberInfo o2) {
            boolean b2;
            boolean b1 = this.clusterService.getMember(o1.getAddress()) != null;
            boolean bl = b2 = this.clusterService.getMember(o2.getAddress()) != null;
            return b1 == b2 ? 0 : (b1 ? -1 : 1);
        }
    }
}

