/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpBadRequestException;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpForbiddenException;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.dto.WanReplicationConfigDTO;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.impl.LoggingServiceImpl;
import com.hazelcast.version.Version;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.wan.impl.WanReplicationService;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private static final byte[] QUEUE_SIMPLE_VALUE_CONTENT_TYPE = StringUtil.stringToBytes("text/plain");

    public HttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService, textCommandService.getNode().getLogger(HttpPostCommandProcessor.class));
    }

    @Override
    public void handle(HttpPostCommand command) {
        boolean sendResponse = true;
        try {
            String uri = command.getURI();
            if (uri.startsWith("/hazelcast/rest/maps/")) {
                this.handleMap(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/queues/")) {
                this.handleQueue(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/state")) {
                this.handleGetClusterState(command);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/changeState")) {
                this.handleChangeClusterState(command);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/version")) {
                this.handleChangeClusterVersion(command);
            } else {
                if (uri.startsWith("/hazelcast/rest/management/cluster/clusterShutdown")) {
                    this.handleClusterShutdown(command);
                    return;
                }
                if (uri.startsWith("/hazelcast/rest/management/cluster/forceStart")) {
                    this.handleForceStart(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/hotBackupInterrupt")) {
                    this.handleHotRestartBackupInterrupt(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/hotBackup")) {
                    this.handleHotRestartBackup(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/partialStart")) {
                    this.handlePartialStart(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/nodes")) {
                    this.handleListNodes(command);
                } else {
                    if (uri.startsWith("/hazelcast/rest/management/cluster/memberShutdown")) {
                        this.handleShutdownNode(command);
                        return;
                    }
                    if (uri.startsWith("/hazelcast/rest/wan/sync/map")) {
                        this.handleWanSyncMap(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/sync/allmaps")) {
                        this.handleWanSyncAllMaps(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/clearWanQueues")) {
                        this.handleWanClearQueues(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/addWanConfig")) {
                        this.handleAddWanConfig(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/pausePublisher")) {
                        this.handleWanPausePublisher(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/stopPublisher")) {
                        this.handleWanStopPublisher(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/resumePublisher")) {
                        this.handleWanResumePublisher(command);
                    } else if (uri.startsWith("/hazelcast/rest/wan/consistencyCheck/map")) {
                        this.handleWanConsistencyCheck(command);
                    } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/members")) {
                        this.handleCPMember(command);
                        sendResponse = false;
                    } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/groups")) {
                        this.handleCPGroup(command);
                        sendResponse = false;
                    } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/reset")) {
                        this.handleResetCPSubsystem(command);
                        sendResponse = false;
                    } else if (uri.startsWith("/hazelcast/rest/license")) {
                        this.handleSetLicense(command);
                    } else if (uri.startsWith("/hazelcast/rest/log-level/reset")) {
                        this.handleLogLevelReset(command);
                    } else if (uri.startsWith("/hazelcast/rest/log-level")) {
                        this.handleLogLevelSet(command);
                    } else {
                        command.send404();
                    }
                }
            }
        }
        catch (HttpBadRequestException e) {
            this.prepareResponse(HttpCommand.RES_400, command, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.FAIL, "message", e.getMessage()));
            sendResponse = true;
        }
        catch (HttpForbiddenException e) {
            this.prepareResponse(HttpCommand.RES_403, command, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.FAIL, "message", "unauthenticated"));
            sendResponse = true;
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + command, e);
            this.prepareResponse(HttpCommand.RES_500, command, HttpPostCommandProcessor.exceptionResponse(e));
        }
        if (sendResponse) {
            this.textCommandService.sendResponse(command);
        }
    }

    private void handleChangeClusterState(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 3);
        ClusterServiceImpl clusterService = this.getNode().getClusterService();
        ClusterState state = ClusterState.valueOf(StringUtil.upperCaseInternal(params[2]));
        if (!state.equals((Object)clusterService.getClusterState())) {
            clusterService.changeClusterState(state);
            JsonObject res = HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "state", state.toString().toLowerCase(StringUtil.LOCALE_INTERNAL));
            this.prepareResponse(cmd, res);
        } else {
            JsonObject res = HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.FAIL, "state", state.toString().toLowerCase(StringUtil.LOCALE_INTERNAL));
            this.prepareResponse(cmd, res);
        }
    }

    private void handleGetClusterState(HttpPostCommand cmd) throws Throwable {
        this.decodeParamsAndAuthenticate(cmd, 2);
        ClusterServiceImpl clusterService = this.getNode().getClusterService();
        ClusterState clusterState = clusterService.getClusterState();
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "state", StringUtil.lowerCaseInternal(clusterState.toString())));
    }

    private void handleChangeClusterVersion(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 3);
        ClusterServiceImpl clusterService = this.getNode().getClusterService();
        Version version = Version.of(params[2]);
        clusterService.changeClusterVersion(version);
        JsonObject rsp = HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "version", clusterService.getClusterVersion().toString());
        this.prepareResponse(cmd, rsp);
    }

    private void handleForceStart(HttpPostCommand cmd) throws Throwable {
        this.decodeParamsAndAuthenticate(cmd, 2);
        boolean success = this.getNode().getNodeExtension().getInternalHotRestartService().triggerForceStart();
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(success ? HttpCommandProcessor.ResponseType.SUCCESS : HttpCommandProcessor.ResponseType.FAIL, new String[0]));
    }

    private void handlePartialStart(HttpPostCommand cmd) throws Throwable {
        this.decodeParamsAndAuthenticate(cmd, 2);
        boolean success = this.getNode().getNodeExtension().getInternalHotRestartService().triggerPartialStart();
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(success ? HttpCommandProcessor.ResponseType.SUCCESS : HttpCommandProcessor.ResponseType.FAIL, new String[0]));
    }

    private void handleHotRestartBackup(HttpPostCommand cmd) throws Throwable {
        this.decodeParamsAndAuthenticate(cmd, 2);
        this.getNode().getNodeExtension().getHotRestartService().backup();
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, new String[0]));
    }

    private void handleHotRestartBackupInterrupt(HttpPostCommand cmd) throws Throwable {
        this.decodeParamsAndAuthenticate(cmd, 2);
        this.getNode().getNodeExtension().getHotRestartService().interruptBackupTask();
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, new String[0]));
    }

    private void handleClusterShutdown(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        ClusterServiceImpl clusterService = this.getNode().getClusterService();
        this.sendResponse(command, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, new String[0]));
        clusterService.shutdown();
    }

    private void handleListNodes(HttpPostCommand cmd) throws Throwable {
        this.decodeParamsAndAuthenticate(cmd, 2);
        ClusterServiceImpl clusterService = this.getNode().getClusterService();
        String responseTxt = clusterService.getMembers().toString() + "\n" + this.getNode().getBuildInfo().getVersion() + "\n" + System.getProperty("java.version");
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "response", responseTxt));
    }

    private void handleShutdownNode(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        this.sendResponse(command, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, new String[0]));
        this.getNode().hazelcastInstance.shutdown();
    }

    private void handleQueue(HttpPostCommand command, String uri) {
        byte[] contentType;
        byte[] data;
        String queueName;
        String suffix;
        String simpleValue = null;
        int baseUriLength = "/hazelcast/rest/queues/".length();
        if (uri.endsWith("/")) {
            int requestedUriLength = uri.length();
            if (baseUriLength == requestedUriLength) {
                throw new HttpBadRequestException("Missing queue name");
            }
            suffix = uri.substring(baseUriLength, requestedUriLength - 1);
        } else {
            suffix = uri.substring(baseUriLength);
        }
        int indexSlash = suffix.lastIndexOf(47);
        if (indexSlash == -1) {
            queueName = suffix;
        } else {
            queueName = suffix.substring(0, indexSlash);
            simpleValue = suffix.substring(indexSlash + 1);
        }
        if (simpleValue == null) {
            data = command.getData();
            contentType = command.getContentType();
        } else {
            data = StringUtil.stringToBytes(simpleValue);
            contentType = QUEUE_SIMPLE_VALUE_CONTENT_TYPE;
        }
        boolean offerResult = this.textCommandService.offer(queueName, new RestValue(data, contentType));
        if (offerResult) {
            command.send200();
        } else {
            command.send503();
        }
    }

    private void handleMap(HttpPostCommand command, String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash(uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        if (indexEnd == -1) {
            throw new HttpBadRequestException("Missing map name");
        }
        String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
        String key = uri.substring(indexEnd + 1);
        byte[] data = command.getData();
        this.textCommandService.put(mapName, key, new RestValue(data, command.getContentType()), -1);
        command.send200();
    }

    private void handleWanSyncMap(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 5);
        String wanRepName = params[2];
        String publisherId = params[3];
        String mapName = params[4];
        UUID uuid = this.getNode().getNodeEngine().getWanReplicationService().syncMap(wanRepName, publisherId, mapName);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "Sync initiated", "uuid", uuid.toString()));
    }

    private void handleWanSyncAllMaps(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 4);
        String wanRepName = params[2];
        String publisherId = params[3];
        UUID uuid = this.getNode().getNodeEngine().getWanReplicationService().syncAllMaps(wanRepName, publisherId);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "Sync initiated", "uuid", uuid.toString()));
    }

    private void handleWanConsistencyCheck(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 5);
        String wanReplicationName = params[2];
        String publisherId = params[3];
        String mapName = params[4];
        WanReplicationService service = this.getNode().getNodeEngine().getWanReplicationService();
        UUID uuid = service.consistencyCheck(wanReplicationName, publisherId, mapName);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "Consistency check initiated", "uuid", uuid.toString()));
    }

    private void handleWanClearQueues(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 4);
        String wanRepName = params[2];
        String publisherId = params[3];
        this.getNode().getNodeEngine().getWanReplicationService().removeWanEvents(wanRepName, publisherId);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "WAN replication queues are cleared."));
    }

    private void handleAddWanConfig(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 3);
        String wanConfigJson = params[2];
        WanReplicationConfigDTO dto = new WanReplicationConfigDTO(new WanReplicationConfig());
        dto.fromJson(Json.parse(wanConfigJson).asObject());
        AddWanConfigResult result = this.getNode().getNodeEngine().getWanReplicationService().addWanReplicationConfig(dto.getConfig());
        JsonObject res = HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "WAN configuration added.");
        res.add("addedPublisherIds", Json.array(result.getAddedPublisherIds().toArray(new String[0])));
        res.add("ignoredPublisherIds", Json.array(result.getIgnoredPublisherIds().toArray(new String[0])));
        this.prepareResponse(cmd, res);
    }

    private void handleWanPausePublisher(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 4);
        String wanReplicationName = params[2];
        String publisherId = params[3];
        WanReplicationService service = this.getNode().getNodeEngine().getWanReplicationService();
        service.pause(wanReplicationName, publisherId);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "WAN publisher paused"));
    }

    private void handleWanStopPublisher(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 4);
        String wanReplicationName = params[2];
        String publisherId = params[3];
        WanReplicationService service = this.getNode().getNodeEngine().getWanReplicationService();
        service.stop(wanReplicationName, publisherId);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "WAN publisher stopped"));
    }

    private void handleWanResumePublisher(HttpPostCommand cmd) throws Throwable {
        String[] params = this.decodeParamsAndAuthenticate(cmd, 4);
        String wanReplicationName = params[2];
        String publisherId = params[3];
        WanReplicationService service = this.getNode().getNodeEngine().getWanReplicationService();
        service.resume(wanReplicationName, publisherId);
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "WAN publisher resumed"));
    }

    private void handleCPMember(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        String uri = command.getURI();
        if (uri.endsWith("/remove") || uri.endsWith("/remove/")) {
            this.handleRemoveCPMember(command);
        } else {
            this.handlePromoteToCPMember(command);
        }
    }

    private void handlePromoteToCPMember(HttpPostCommand command) {
        if (this.getCpSubsystem().getLocalCPMember() != null) {
            command.send200();
            this.textCommandService.sendResponse(command);
            return;
        }
        this.getCpSubsystemManagementService().promoteToCPMember().whenCompleteAsync((response, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while promoting CP member.", (Throwable)t);
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleRemoveCPMember(HttpPostCommand command) {
        String uri = command.getURI();
        String prefix = "/hazelcast/rest/cp-subsystem/members/";
        UUID cpMemberUid = UUID.fromString(uri.substring(prefix.length(), uri.indexOf(47, prefix.length())).trim());
        this.getCpSubsystem().getCPSubsystemManagementService().removeCPMember(cpMemberUid).whenCompleteAsync((respone, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while removing CP member " + cpMemberUid, (Throwable)t);
                if (ExceptionUtil.peel(t) instanceof IllegalArgumentException) {
                    command.send400();
                } else {
                    command.send500();
                }
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleCPGroup(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        String uri = command.getURI();
        if (!uri.endsWith("/remove") && !uri.endsWith("/remove/")) {
            command.send404();
            this.textCommandService.sendResponse(command);
            return;
        }
        if (uri.contains("/sessions")) {
            this.handleForceCloseCPSession(command);
        } else {
            this.handleForceDestroyCPGroup(command);
        }
    }

    private void handleForceCloseCPSession(HttpPostCommand command) {
        String uri = command.getURI();
        String prefix = "/hazelcast/rest/cp-subsystem/groups/";
        String suffix = "/sessions/";
        int i = uri.indexOf(suffix);
        String groupName = uri.substring(prefix.length(), i).trim();
        long sessionId = Long.parseLong(uri.substring(i + suffix.length(), uri.indexOf(47, i + suffix.length())));
        this.getCpSubsystem().getCPSessionManagementService().forceCloseSession(groupName, sessionId).whenCompleteAsync((response, t) -> {
            if (t == null) {
                if (response.booleanValue()) {
                    command.send200();
                } else {
                    command.send400();
                }
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while closing CP session", (Throwable)t);
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleForceDestroyCPGroup(HttpPostCommand command) {
        String prefix;
        String uri = command.getURI();
        String groupName = uri.substring((prefix = "/hazelcast/rest/cp-subsystem/groups/").length(), uri.indexOf(47, prefix.length())).trim();
        if ("METADATA".equals(groupName)) {
            command.send400();
            this.textCommandService.sendResponse(command);
            return;
        }
        this.getCpSubsystem().getCPSubsystemManagementService().forceDestroyCPGroup(groupName).whenCompleteAsync((response, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while destroying CP group " + groupName, (Throwable)t);
                if (ExceptionUtil.peel(t) instanceof IllegalArgumentException) {
                    command.send400();
                } else {
                    command.send500();
                }
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleResetCPSubsystem(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        this.getCpSubsystem().getCPSubsystemManagementService().reset().whenCompleteAsync((response, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while resetting CP subsystem", (Throwable)t);
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private CPSubsystemManagementService getCpSubsystemManagementService() {
        return this.getCpSubsystem().getCPSubsystemManagementService();
    }

    private CPSubsystem getCpSubsystem() {
        return this.getNode().getNodeEngine().getHazelcastInstance().getCPSubsystem();
    }

    @Override
    public void handleRejection(HttpPostCommand command) {
        this.handle(command);
    }

    protected void handleSetLicense(HttpPostCommand cmd) throws Throwable {
        this.prepareResponse(cmd, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, new String[0]));
    }

    private void handleLogLevelSet(HttpPostCommand command) throws UnsupportedEncodingException {
        String[] params = this.decodeParamsAndAuthenticate(command, 3);
        String level = params[2];
        LoggingServiceImpl loggingService = (LoggingServiceImpl)this.getNode().getLoggingService();
        loggingService.setLevel(level);
        this.prepareResponse(command, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "log level is changed"));
    }

    private void handleLogLevelReset(HttpPostCommand command) throws UnsupportedEncodingException {
        this.decodeParamsAndAuthenticate(command, 2);
        LoggingServiceImpl loggingService = (LoggingServiceImpl)this.getNode().getLoggingService();
        loggingService.resetLevel();
        this.prepareResponse(command, HttpPostCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, "message", "log level is reset"));
    }
}

