/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.exec.io.AbstractMailbox;
import com.hazelcast.sql.impl.exec.io.InboundBatch;
import com.hazelcast.sql.impl.exec.io.InboundHandler;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControl;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;

public abstract class AbstractInbox
extends AbstractMailbox
implements InboundHandler {
    private static final Comparator<InboundBatch> BATCH_COMPARATOR = (b1, b2) -> Long.compare(b1.getOrdinal(), b2.getOrdinal());
    protected int enqueuedBatches;
    private int remainingStreams;
    private final boolean ordered;
    private final QueryOperationHandler operationHandler;
    private final FlowControl flowControl;
    private final Map<UUID, SenderState> states;

    protected AbstractInbox(QueryOperationHandler operationHandler, QueryId queryId, int edgeId, boolean ordered, int rowWidth, UUID localMemberId, int remainingStreams, FlowControl flowControl) {
        super(queryId, edgeId, rowWidth, localMemberId);
        this.ordered = ordered;
        this.operationHandler = operationHandler;
        this.remainingStreams = remainingStreams;
        this.flowControl = flowControl;
        this.states = new HashMap<UUID, SenderState>(remainingStreams);
    }

    public void setup() {
        this.flowControl.setup(this.queryId, this.edgeId, this.localMemberId, this.operationHandler);
    }

    @Override
    public final void onBatch(InboundBatch batch, long remainingMemory) {
        ++this.enqueuedBatches;
        this.flowControl.onBatchAdded(batch.getSenderId(), this.getBatchSize(batch), batch.isLast(), remainingMemory);
        SenderState state = this.states.get(batch.getSenderId());
        if (state == null) {
            state = new SenderState();
            this.states.put(batch.getSenderId(), state);
        }
        state.onBatch(batch);
    }

    protected abstract void onBatch0(InboundBatch var1);

    protected void onBatchPolled(InboundBatch batch) {
        if (batch == null) {
            return;
        }
        --this.enqueuedBatches;
        this.flowControl.onBatchRemoved(batch.getSenderId(), this.getBatchSize(batch), batch.isLast());
    }

    @Override
    public void onFragmentExecutionCompleted() {
        this.flowControl.onFragmentExecutionCompleted();
    }

    public boolean closed() {
        return this.enqueuedBatches == 0 && this.remainingStreams == 0;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public int getRemainingStreams() {
        return this.remainingStreams;
    }

    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    private long getBatchSize(InboundBatch batch) {
        return (long)batch.getBatch().getRowCount() * (long)this.rowWidth;
    }

    private class SenderState {
        private long expectedOrdinal;
        private PriorityQueue<InboundBatch> pendingBatches;
        private long processedBatchesCount;
        private long maximumBatchesCount;

        private SenderState() {
        }

        private void onBatch(InboundBatch batch) {
            if (!AbstractInbox.this.ordered) {
                this.processBatch(batch);
                return;
            }
            if (batch.getOrdinal() == this.expectedOrdinal) {
                long expectedOrdinal0;
                this.processBatch(batch);
                if (this.pendingBatches != null) {
                    InboundBatch nextBatch;
                    for (expectedOrdinal0 = this.expectedOrdinal + 1L; (nextBatch = this.pendingBatches.peek()) != null && nextBatch.getOrdinal() == expectedOrdinal0; ++expectedOrdinal0) {
                        this.pendingBatches.poll();
                        this.processBatch(nextBatch);
                    }
                }
                this.expectedOrdinal = expectedOrdinal0;
                return;
            }
            if (this.pendingBatches == null) {
                this.pendingBatches = new PriorityQueue(1, BATCH_COMPARATOR);
            }
            this.pendingBatches.add(batch);
        }

        private void processBatch(InboundBatch batch) {
            AbstractInbox.this.onBatch0(batch);
            ++this.processedBatchesCount;
            if (batch.isLast()) {
                this.maximumBatchesCount = batch.getOrdinal() + 1L;
            }
            if (this.maximumBatchesCount > 0L && this.maximumBatchesCount == this.processedBatchesCount) {
                AbstractInbox.this.remainingStreams--;
            }
        }
    }
}

