/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.worker;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.LocalMemberIdProvider;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.operation.QueryCancelOperation;
import com.hazelcast.sql.impl.operation.QueryOperation;
import com.hazelcast.sql.impl.operation.QueryOperationDeserializationException;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.worker.QueryOperationExecutable;
import java.util.UUID;

public class QueryPoolTask
implements Runnable {
    private final QueryOperationExecutable task;
    private final LocalMemberIdProvider localMemberIdProvider;
    private final QueryOperationHandler operationHandler;
    private final SerializationService ss;
    private final ILogger logger;

    public QueryPoolTask(QueryOperationExecutable task, LocalMemberIdProvider localMemberIdProvider, QueryOperationHandler operationHandler, SerializationService ss, ILogger logger) {
        this.task = task;
        this.localMemberIdProvider = localMemberIdProvider;
        this.operationHandler = operationHandler;
        this.ss = ss;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            this.execute(this.task);
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            this.logger.severe(t);
        }
    }

    private void execute(QueryOperationExecutable task) {
        QueryOperation operation;
        if (task.isLocal()) {
            operation = task.getLocalOperation();
        } else {
            operation = this.deserialize(task.getRemoteOperation());
            if (operation == null) {
                return;
            }
        }
        assert (operation != null);
        this.operationHandler.execute(operation);
    }

    private QueryOperation deserialize(Packet packet) {
        try {
            return (QueryOperation)this.ss.toObject(packet);
        }
        catch (Exception e) {
            if (e.getCause() instanceof QueryOperationDeserializationException) {
                QueryOperationDeserializationException error = (QueryOperationDeserializationException)e.getCause();
                this.sendDeserializationError(error);
            } else {
                this.logger.severe("Failed to deserialize query operation received from " + packet.getConn().getRemoteAddress() + " (will be ignored)", e);
            }
            return null;
        }
    }

    private void sendDeserializationError(QueryOperationDeserializationException e) {
        QueryId queryId = e.getQueryId();
        UUID localMemberId = this.localMemberIdProvider.getLocalMemberId();
        UUID targetMemberId = e.getCallerId();
        UUID initiatorMemberId = queryId.getMemberId();
        QueryCancelOperation cancelOperation = new QueryCancelOperation(queryId, -1, "Failed to deserialize " + e.getOperationClassName() + " received from " + targetMemberId + ": " + e.getMessage(), localMemberId);
        this.operationHandler.submit(localMemberId, initiatorMemberId, cancelOperation);
    }
}

