/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.provider;

import com.sun.enterprise.security.jacc.provider.SimplePolicyConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

public class SharedState {
    private static final Logger logger = Logger.getLogger(SharedState.class.getPackage().getName());
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private static Lock readLock = rwLock.readLock();
    private static Lock writeLock = rwLock.writeLock();
    private static HashMap<String, SimplePolicyConfiguration> configTable = new HashMap();
    private static HashMap<String, HashSet<String>> linkTable = new HashMap();

    private SharedState() {
    }

    static Logger getLogger() {
        return logger;
    }

    static SimplePolicyConfiguration lookupConfig(String pcid) {
        SimplePolicyConfiguration pc = null;
        writeLock.lock();
        try {
            pc = configTable.get(pcid);
        }
        finally {
            writeLock.unlock();
        }
        return pc;
    }

    static SimplePolicyConfiguration getConfig(String pcid, boolean remove) {
        SimplePolicyConfiguration pc = null;
        writeLock.lock();
        try {
            pc = configTable.get(pcid);
            if (pc == null) {
                pc = new SimplePolicyConfiguration(pcid);
                SharedState.initLinks(pcid);
                configTable.put(pcid, pc);
            } else if (remove) {
                SharedState.removeLinks(pcid);
            }
        }
        finally {
            writeLock.unlock();
        }
        return pc;
    }

    static SimplePolicyConfiguration getActiveConfig() throws PolicyContextException {
        String contextId = PolicyContext.getContextID();
        SimplePolicyConfiguration policyConfiguration = null;
        if (contextId != null) {
            readLock.lock();
            try {
                policyConfiguration = configTable.get(contextId);
                if (policyConfiguration == null) {
                    SimplePolicyConfiguration.logException(Level.WARNING, "invalid policy context id", new PolicyContextException());
                }
            }
            finally {
                readLock.unlock();
            }
            if (policyConfiguration != null && !policyConfiguration.inService()) {
                SimplePolicyConfiguration.logException(Level.FINEST, "invalid policy context state", new PolicyContextException());
                policyConfiguration = null;
            }
        }
        return policyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void link(String id, String otherId) throws PolicyContextException {
        writeLock.lock();
        try {
            if (otherId.equals(id)) {
                throw new IllegalArgumentException("Operation attempted to link PolicyConfiguration to itself.");
            }
            HashSet<String> linkSet = linkTable.get(id);
            HashSet<String> otherLinkSet = linkTable.get(otherId);
            if (otherLinkSet == null) {
                throw new RuntimeException("Linked policy configuration (" + otherId + ") does not exist");
            }
            for (String nextid : otherLinkSet) {
                linkSet.add(nextid);
                linkTable.put(nextid, linkSet);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    static void initLinks(String id) {
        HashSet<String> linkSet = new HashSet<String>();
        linkSet.add(id);
        linkTable.put(id, linkSet);
    }

    static void removeLinks(String id) {
        writeLock.lock();
        try {
            HashSet<String> linkSet = linkTable.get(id);
            if (linkSet != null) {
                linkSet.remove(id);
                linkTable.remove(id);
            }
            SharedState.initLinks(id);
        }
        finally {
            writeLock.unlock();
        }
    }
}

