/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.ClassPathBuilder;
import com.sun.enterprise.admin.cli.optional.DBControl;
import com.sun.enterprise.admin.cli.optional.DBManager;
import com.sun.enterprise.admin.cli.optional.H2Control;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.admin.CommandException;

public class H2Manager
extends DBManager {
    @Override
    public Class<? extends DBControl> getDBControl() {
        return H2Control.class;
    }

    @Override
    public String getLogFileName() {
        return "h2.log";
    }

    @Override
    public List<String> getSystemProperty() {
        return Collections.emptyList();
    }

    @Override
    public String getRootProperty() {
        return "fish.payara.aas.h2Root";
    }

    @Override
    public void checkIfDbInstalled(File dbLocation) throws CommandException {
        if (!dbLocation.exists()) {
            throw new CommandException("dblocation not found: " + dbLocation);
        }
        File dbJar = new File(new File(dbLocation, "bin"), "h2.jar");
        if (!dbJar.exists()) {
            throw new CommandException("h2.jar not found in " + dbLocation);
        }
    }

    @Override
    public void buildDatabaseClasspath(File dbLocation, ClassPathBuilder sDatabaseClasspath) throws CommandException {
        sDatabaseClasspath.add(dbLocation, new String[]{"bin", "h2.jar"});
    }
}

