/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.WeldBean;
import org.jboss.weld.bootstrap.BeanDeploymentFinder;
import org.jboss.weld.bootstrap.event.WeldBeanConfigurator;
import org.jboss.weld.bootstrap.events.configurator.BeanAttributesConfiguratorImpl;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.ForwardingWeldInstance;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class BeanConfiguratorImpl<T>
implements WeldBeanConfigurator<T>,
Configurator<Bean<T>> {
    private final BeanManagerImpl beanManager;
    private Class<?> beanClass;
    private final Set<InjectionPoint> injectionPoints;
    private final BeanAttributesConfiguratorImpl<T> attributes;
    private String id;
    private CreateCallback<T> createCallback;
    private DestroyCallback<T> destroyCallback;
    private Integer priority = null;

    public BeanConfiguratorImpl(Class<?> defaultBeanClass, BeanDeploymentFinder beanDeploymentFinder) {
        this.beanClass = defaultBeanClass;
        this.injectionPoints = new HashSet<InjectionPoint>();
        this.beanManager = beanDeploymentFinder.getOrCreateBeanDeployment(this.beanClass).getBeanManager();
        this.attributes = new BeanAttributesConfiguratorImpl(this.beanManager);
    }

    @Override
    public WeldBeanConfigurator<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> beanClass(Class<?> beanClass) {
        Preconditions.checkArgumentNotNull(beanClass);
        this.beanClass = beanClass;
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addInjectionPoint(InjectionPoint injectionPoint) {
        Preconditions.checkArgumentNotNull(injectionPoint);
        this.injectionPoints.add(injectionPoint);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addInjectionPoints(InjectionPoint ... injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints);
        Collections.addAll(this.injectionPoints, injectionPoints);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addInjectionPoints(Set<InjectionPoint> injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints);
        this.injectionPoints.addAll(injectionPoints);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> injectionPoints(InjectionPoint ... injectionPoints) {
        this.injectionPoints.clear();
        return this.addInjectionPoints(injectionPoints);
    }

    @Override
    public WeldBeanConfigurator<T> injectionPoints(Set<InjectionPoint> injectionPoints) {
        this.injectionPoints.clear();
        return this.addInjectionPoints((Set)injectionPoints);
    }

    @Override
    public WeldBeanConfigurator<T> id(String id) {
        Preconditions.checkArgumentNotNull(id);
        this.id = id;
        return this;
    }

    @Override
    public <U extends T> WeldBeanConfigurator<U> createWith(Function<CreationalContext<U>, U> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromCreateWith(callback));
        return (WeldBeanConfigurator)Reflections.cast(this);
    }

    @Override
    public <U extends T> WeldBeanConfigurator<U> produceWith(Function<Instance<Object>, U> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromProduceWith(callback));
        return (WeldBeanConfigurator)Reflections.cast(this);
    }

    @Override
    public WeldBeanConfigurator<T> destroyWith(BiConsumer<T, CreationalContext<T>> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.destroyCallback = DestroyCallback.fromDestroy(callback);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> disposeWith(BiConsumer<T, Instance<Object>> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.destroyCallback = DestroyCallback.fromDispose(callback);
        return this;
    }

    @Override
    public <U extends T> WeldBeanConfigurator<U> read(AnnotatedType<U> type) {
        Preconditions.checkArgumentNotNull(type);
        InjectionTarget injectionTarget = (InjectionTarget)Reflections.cast(this.beanManager.getInjectionTargetFactory((AnnotatedType)type).createInjectionTarget((Bean)null));
        this.addInjectionPoints(injectionTarget.getInjectionPoints());
        this.createWith((T c) -> {
            Object instance = injectionTarget.produce(c);
            injectionTarget.inject(instance, c);
            injectionTarget.postConstruct(instance);
            return instance;
        });
        this.destroyWith((T i, U c) -> {
            injectionTarget.preDestroy(i);
            c.release();
        });
        BeanAttributes<U> beanAttributes = this.beanManager.createBeanAttributes(type);
        this.read((BeanAttributes)beanAttributes);
        return (WeldBeanConfigurator)Reflections.cast(this);
    }

    @Override
    public WeldBeanConfigurator<T> read(BeanAttributes<?> beanAttributes) {
        Preconditions.checkArgumentNotNull(beanAttributes);
        this.attributes.read(beanAttributes);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addType(Type type) {
        Preconditions.checkArgumentNotNull(type);
        this.attributes.addType(type);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addType(TypeLiteral<?> typeLiteral) {
        Preconditions.checkArgumentNotNull(typeLiteral);
        this.attributes.addType(typeLiteral.getType());
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addTypes(Type ... types) {
        Preconditions.checkArgumentNotNull(types);
        this.attributes.addTypes(types);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addTypes(Set<Type> types) {
        Preconditions.checkArgumentNotNull(types);
        this.attributes.addTypes(types);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addTransitiveTypeClosure(Type type) {
        Preconditions.checkArgumentNotNull(type);
        this.attributes.addTransitiveTypeClosure(type);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> types(Type ... types) {
        Preconditions.checkArgumentNotNull(types);
        this.attributes.types(types);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> types(Set<Type> types) {
        Preconditions.checkArgumentNotNull(types);
        this.attributes.types(types);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> scope(Class<? extends Annotation> scope) {
        Preconditions.checkArgumentNotNull(scope);
        this.attributes.scope(scope);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addQualifier(Annotation qualifier) {
        Preconditions.checkArgumentNotNull(qualifier);
        this.attributes.addQualifier(qualifier);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.attributes.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.attributes.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> qualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.attributes.qualifiers(qualifiers);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.attributes.qualifiers(qualifiers);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        Preconditions.checkArgumentNotNull(stereotype);
        this.attributes.addStereotype(stereotype);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        Preconditions.checkArgumentNotNull(stereotypes);
        this.attributes.addStereotypes(stereotypes);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        Preconditions.checkArgumentNotNull(stereotypes);
        this.attributes.stereotypes(stereotypes);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> name(String name) {
        this.attributes.name(name);
        return this;
    }

    @Override
    public WeldBeanConfigurator<T> alternative(boolean alternative) {
        this.attributes.alternative(alternative);
        return this;
    }

    @Override
    public Bean<T> complete() {
        if (this.createCallback == null) {
            throw BeanLogger.LOG.noCallbackSpecifiedForCustomBean("bean [" + this.beanClass.toString() + ", with types: " + Formats.formatTypes(this.attributes.types) + ", and qualifiers: " + Formats.formatAnnotations(this.attributes.qualifiers) + "]");
        }
        return new ImmutableBean(this);
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    static class ImmutableBean<T>
    extends ForwardingBeanAttributes<T>
    implements WeldBean<T>,
    PassivationCapable {
        private final String id;
        private final Integer priority;
        private final BeanManagerImpl beanManager;
        private final Class<?> beanClass;
        private final BeanAttributes<T> attributes;
        private final Set<InjectionPoint> injectionPoints;
        private final CreateCallback<T> createCallback;
        private final DestroyCallback<T> destroyCallback;

        ImmutableBean(BeanConfiguratorImpl<T> configurator) {
            this.beanManager = configurator.getBeanManager();
            this.beanClass = ((BeanConfiguratorImpl)configurator).beanClass;
            this.attributes = ((BeanConfiguratorImpl)configurator).attributes.complete();
            this.injectionPoints = ImmutableSet.copyOf(((BeanConfiguratorImpl)configurator).injectionPoints);
            this.createCallback = ((BeanConfiguratorImpl)configurator).createCallback;
            this.destroyCallback = ((BeanConfiguratorImpl)configurator).destroyCallback;
            this.priority = ((BeanConfiguratorImpl)configurator).priority;
            this.id = ((BeanConfiguratorImpl)configurator).id != null ? ((BeanConfiguratorImpl)configurator).id : BeanIdentifiers.forBuilderBean(this.attributes, this.beanClass);
        }

        public T create(CreationalContext<T> creationalContext) {
            return (T)((CreateCallback)this.createCallback).create(this, creationalContext, this.beanManager);
        }

        public void destroy(T instance, CreationalContext<T> creationalContext) {
            if (this.destroyCallback != null) {
                this.destroyCallback.destroy(instance, creationalContext, this.beanManager);
            }
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public BeanIdentifier getIdentifier() {
            return new StringBeanIdentifier(this.id);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public boolean isNullable() {
            return false;
        }

        @Override
        protected BeanAttributes<T> attributes() {
            return this.attributes;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        public String toString() {
            return "Configurator Bean [" + this.getBeanClass().toString() + ", types: " + Formats.formatTypes(this.getTypes()) + ", qualifiers: " + Formats.formatAnnotations(this.getQualifiers()) + "]";
        }
    }

    static final class DestroyCallback<T> {
        private final BiConsumer<T, CreationalContext<T>> destroy;
        private final BiConsumer<T, Instance<Object>> dispose;

        static <T> DestroyCallback<T> fromDispose(BiConsumer<T, Instance<Object>> callback) {
            return new DestroyCallback<T>(callback, null);
        }

        static <T> DestroyCallback<T> fromDestroy(BiConsumer<T, CreationalContext<T>> callback) {
            return new DestroyCallback<T>(null, callback);
        }

        public DestroyCallback(BiConsumer<T, Instance<Object>> dispose, BiConsumer<T, CreationalContext<T>> destroy) {
            this.destroy = destroy;
            this.dispose = dispose;
        }

        void destroy(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            if (this.dispose != null) {
                this.dispose.accept(instance, beanManager.getInstance(ctx));
            } else {
                this.destroy.accept(instance, ctx);
            }
        }
    }

    static class GuardedInstance<T>
    extends ForwardingWeldInstance<T> {
        private final Bean<?> bean;
        private final WeldInstance<T> delegate;

        public GuardedInstance(Bean<?> bean, WeldInstance<T> delegate) {
            this.bean = bean;
            this.delegate = delegate;
        }

        @Override
        public WeldInstance<T> delegate() {
            return this.delegate;
        }

        @Override
        public <U extends T> WeldInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
            return this.wrap(subtype, (WeldInstance)this.delegate.select((Class)subtype, qualifiers));
        }

        @Override
        public <U extends T> WeldInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
            return this.wrap(subtype.getType(), (WeldInstance)this.delegate.select((TypeLiteral)subtype, qualifiers));
        }

        @Override
        public WeldInstance<T> select(Annotation ... qualifiers) {
            return this.wrap(null, (WeldInstance)this.delegate.select(qualifiers));
        }

        @Override
        public <X> WeldInstance<X> select(Type subtype, Annotation ... qualifiers) {
            return this.wrap(subtype, this.delegate.select(subtype, qualifiers));
        }

        private <TYPE> WeldInstance<TYPE> wrap(Type subtype, WeldInstance<TYPE> delegate) {
            if (subtype != null && InjectionPoint.class.equals((Object)subtype)) {
                throw BeanLogger.LOG.cannotInjectInjectionPointMetadataIntoNonDependent(this.bean);
            }
            return new GuardedInstance<TYPE>(this.bean, delegate);
        }
    }

    static final class CreateCallback<T> {
        private final Supplier<T> simple;
        private final Function<CreationalContext<T>, T> create;
        private final Function<Instance<Object>, T> instance;

        static <T> CreateCallback<T> fromProduceWith(Function<Instance<Object>, T> callback) {
            return new CreateCallback<T>(null, null, callback);
        }

        static <T> CreateCallback<T> fromProduceWith(Supplier<T> callback) {
            return new CreateCallback<T>(callback, null, null);
        }

        static <T> CreateCallback<T> fromCreateWith(Function<CreationalContext<T>, T> callback) {
            return new CreateCallback<T>(null, callback, null);
        }

        CreateCallback(Supplier<T> simple, Function<CreationalContext<T>, T> create, Function<Instance<Object>, T> instance) {
            this.simple = simple;
            this.create = create;
            this.instance = instance;
        }

        private T create(Bean<?> bean, CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            if (this.simple != null) {
                return this.simple.get();
            }
            if (this.instance != null) {
                return this.instance.apply(this.createInstance(bean, ctx, beanManager));
            }
            return this.create.apply(ctx);
        }

        private Instance<Object> createInstance(Bean<?> bean, CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            WeldInstance<Object> instance = beanManager.getInstance(ctx);
            if (Dependent.class.equals((Object)bean.getScope())) {
                return instance;
            }
            return new GuardedInstance<Object>(bean, instance);
        }
    }
}

