/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GlobalXidDecision
implements Externalizable {
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    private GlobalXid _xid = null;
    private int _decision = 0;

    public GlobalXidDecision() {
    }

    public GlobalXidDecision(GlobalXid xid, int decision) {
        if (decision != 0 && decision != 1) {
            throw new IllegalArgumentException("Invalid global decision value: " + decision);
        }
        this._xid = xid;
        this._decision = decision;
    }

    public GlobalXid getGlobalXid() {
        return this._xid;
    }

    public int getGlobalDecision() {
        return this._decision;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this._xid.write(out);
        out.writeInt(this._decision);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._xid = GlobalXid.read(in);
        this._decision = in.readInt();
    }

    private static String decisionString(int d) {
        if (d == 0) {
            return "COMMIT";
        }
        if (d == 1) {
            return "ROLLBACK";
        }
        return "UNKNOWN";
    }

    public String toString() {
        return this._xid.toString() + "(" + GlobalXidDecision.decisionString(this._decision) + ")";
    }
}

