/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.bridgemgr;

import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrStatusEvent;
import com.sun.messaging.bridge.admin.bridgemgr.Globals;
import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.event.CommonCmdStatusEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.jms.ObjectMessage;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;

public class BridgeAdmin
extends BrokerAdminConn {
    private BridgeMgrStatusEvent statusEvent = null;
    private QueueSender _sender = null;

    public BridgeAdmin(String brokerHost, int brokerPort) throws BrokerAdminException {
        this(brokerHost, brokerPort, null, null, -1L, false, -1, -1L);
    }

    public BridgeAdmin(String brokerHost, int brokerPort, String username, String passwd) throws BrokerAdminException {
        this(brokerHost, brokerPort, username, passwd, -1L, false, -1, -1L);
    }

    public BridgeAdmin(String brokerHost, int brokerPort, String username, String passwd, int timeout) throws BrokerAdminException {
        this(brokerHost, brokerPort, username, passwd, timeout, false, -1, -1L);
    }

    public BridgeAdmin(String brokerAddress, String username, String passwd, int timeout, boolean useSSL) throws BrokerAdminException {
        this(brokerAddress, username, passwd, timeout, false, -1, -1L, useSSL);
    }

    public BridgeAdmin(String brokerHost, int brokerPort, String username, String passwd, long timeout, boolean reconnect, int reconnectRetries, long reconnectDelay) throws BrokerAdminException {
        super(brokerHost, brokerPort, username, passwd, timeout, reconnect, reconnectRetries, reconnectDelay);
    }

    public BridgeAdmin(String brokerAddress, String username, String passwd, long timeout, boolean reconnect, int reconnectRetries, long reconnectDelay, boolean useSSL) throws BrokerAdminException {
        super(brokerAddress, username, passwd, timeout, reconnect, reconnectRetries, reconnectDelay, useSSL);
    }

    public BridgeAdmin(Properties brokerAttrs, String username, String passwd, long timeout) throws BrokerAdminException {
        super(brokerAttrs, username, passwd, timeout);
    }

    @Override
    public String getAdminQueueDest() {
        return "__JMQBridgeAdmin";
    }

    @Override
    public String getAdminMessagePropNameMessageType() {
        return "JMQMessageType";
    }

    @Override
    public String getAdminMessagePropNameErrorString() {
        return "JMQErrorString";
    }

    @Override
    public String getAdminMessagePropNameStatus() {
        return "JMQStatus";
    }

    @Override
    public int getAdminMessageStatusOK() {
        return 200;
    }

    @Override
    public int getAdminMessageTypeSHUTDOWN_REPLY() {
        return 30;
    }

    @Override
    public CommonCmdStatusEvent newCommonCmdStatusEvent(int type) {
        return new BridgeMgrStatusEvent(this, this, type);
    }

    @Override
    public CommonCmdStatusEvent getCurrentStatusEvent() {
        return this.statusEvent;
    }

    @Override
    public void clearStatusEvent() {
        this.statusEvent = null;
    }

    private BridgeMgrStatusEvent createStatusEvent(int type, int replyType, String replyTypeString) {
        CommonCmdStatusEvent cse = this.newCommonCmdStatusEvent(type);
        cse.setReplyType(replyType);
        cse.setReplyTypeString(replyTypeString);
        return (BridgeMgrStatusEvent)cse;
    }

    public void sendHelloMessage() throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendHelloMessage *****");
        }
        this.checkIfBusy();
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 28);
            this.statusEvent = this.createStatusEvent(5000, 29, "HELLO_REPLY");
            if (BridgeAdmin.getDebug()) {
                this.printMsgType(28, "HELLO");
                Globals.stdOutPrintln("\tJMQProtocolLevel=440");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveHelloReplyMessage() *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 29, "HELLO_REPLY");
            TemporaryQueue replyTo = (TemporaryQueue)mesg.getJMSReplyTo();
            if (replyTo == null) {
                Globals.stdErrPrintln("HELLO_REPLY protocol error: no JMSReplyTo");
                throw new BrokerAdminException(2);
            }
            if (BridgeAdmin.getDebug()) {
                Globals.stdOutPrintln("*****Got replyQueue from broker: " + replyTo);
            }
            this._sender = this.session.createSender(replyTo);
            this._sender.setDeliveryMode(1);
            if (BridgeAdmin.getDebug()) {
                Globals.stdOutPrintln("***** Created a _sender: " + this._sender);
            }
            this.isConnected = true;
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendCommandMessage(String cmd, String bridgeName, String bridgeType, String linkName, int msgType, String msgTypeString, int eventType, int replyType, String replyTypeString) throws BrokerAdminException {
        this.sendCommandMessage(cmd, bridgeName, bridgeType, linkName, msgType, msgTypeString, eventType, replyType, replyTypeString, false);
    }

    public void sendCommandMessage(String cmd, String bridgeName, String bridgeType, String linkName, int msgType, String msgTypeString, int eventType, int replyType, String replyTypeString, boolean debugMode) throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** send " + cmd + " Message *****");
        }
        this.checkIfBusy();
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", msgType);
            if (bridgeName != null) {
                mesg.setStringProperty("JMQBridgeName", bridgeName);
            }
            if (bridgeType != null) {
                mesg.setStringProperty("JMQBridgeType", bridgeType);
            }
            if (linkName != null) {
                mesg.setStringProperty("JMQLinkName", linkName);
            }
            if (debugMode) {
                mesg.setBooleanProperty("JMQDebug", debugMode);
            }
            Locale locale = Locale.getDefault();
            mesg.setStringProperty("JMQLocaleLanguage", locale.getLanguage());
            mesg.setStringProperty("JMQLocaleCountry", locale.getCountry());
            mesg.setStringProperty("JMQLocaleVariant", locale.getVariant());
            this.statusEvent = this.createStatusEvent(eventType, replyType, replyTypeString);
            if (BridgeAdmin.getDebug()) {
                this.printMsgType(msgType, msgTypeString);
                Globals.stdOutPrintln("\tJMQBridgeName=" + bridgeName);
                Globals.stdOutPrintln("\tJMQBridgeType=" + bridgeType);
                Globals.stdOutPrintln("\tJMQLinkName=" + linkName);
            }
            this._sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public boolean receiveCommandReplyMessage(String cmd, int replyType, String replyTypeString) throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receive " + replyTypeString + " Message() *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, replyType, replyTypeString);
            if (replyType == 25) {
                return !mesg.getBooleanProperty("JMQAsyncStarted");
            }
            return true;
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
            return true;
        }
    }

    public ArrayList<BridgeCmdSharedReplyData> receiveListReplyMessage() throws BrokerAdminException {
        return this.receiveListReplyMessage(true);
    }

    public ArrayList<BridgeCmdSharedReplyData> receiveListReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveListReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            Serializable obj;
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 19, "LIST_REPLY");
            if (BridgeAdmin.getDebug()) {
                Globals.stdErrPrintln("Received list reply: " + mesg);
            }
            if ((obj = mesg.getObject()) != null && obj instanceof ArrayList) {
                return (ArrayList)obj;
            }
            if (BridgeAdmin.getDebug()) {
                Globals.stdErrPrintln("Unexpected reply from broker: " + obj);
            }
            throw new RuntimeException("Unexpected reply type " + obj + " for LIST");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
            return null;
        }
    }

    public void sendDebugMessage(String debugArg, String targetName, Properties props) throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** send debug " + debugArg + " Message *****");
        }
        this.checkIfBusy();
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 16);
            if (debugArg != null) {
                mesg.setStringProperty("JMQCommandArg", debugArg);
            }
            if (targetName != null) {
                mesg.setStringProperty("JMQTarget", targetName);
            }
            if (props != null) {
                mesg.setObject(props);
            }
            Locale locale = Locale.getDefault();
            mesg.setStringProperty("JMQLocaleLanguage", locale.getLanguage());
            mesg.setStringProperty("JMQLocaleCountry", locale.getCountry());
            mesg.setStringProperty("JMQLocaleVariant", locale.getVariant());
            this.statusEvent = this.createStatusEvent(5006, 17, "DEBUG_REPLY");
            if (BridgeAdmin.getDebug()) {
                this.printMsgType(16, "DEBUG");
                Globals.stdOutPrintln("\tJMQCommandArg=" + debugArg);
                Globals.stdOutPrintln("\tJMQTarget=" + targetName);
            }
            this._sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Hashtable receiveDebugReplyMessage() throws BrokerAdminException {
        return this.receiveDebugReplyMessage(true);
    }

    public Hashtable receiveDebugReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BridgeAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveDebugReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 17, "DEBUG_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Hashtable) {
                return (Hashtable)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    private void printMsgType(int msgType, String msgTypeString) {
        Globals.stdOutPrintln("\tJMQMessageType=" + msgType + "(" + msgTypeString + ")");
    }
}

