/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.command;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.command.AbstractConfigModularityCommand;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.STANDALONE_INSTANCE, CommandTarget.DOMAIN})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-module-config")
@PerLookup
@I18n(value="delete.module.config")
public final class DeleteModuleConfigCommand
extends AbstractConfigModularityCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final Logger LOG = ConfigApiLoggerInfo.getLogger();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteModuleConfigCommand.class);
    private static final String DEFAULT_FORMAT = "";
    private ActionReport report;
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Param(name="serviceName", primary=true)
    private String serviceName;
    @Inject
    ServerEnvironment serverenv;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        if (this.target != null) {
            Config newConfig = this.getConfigForName(this.target, this.serviceLocator, this.domain);
            if (newConfig != null) {
                this.config = newConfig;
            }
            if (this.config == null) {
                this.report.setMessage(localStrings.getLocalString("delete.module.config.target.name.invalid", "The target name specified is invalid. Please double check the target name and try again."));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.serviceName == null) {
            this.report.setMessage(localStrings.getLocalString("delete.module.config.service.name.is.required", "The service name is required, please specify which service you want to delete its default configuration."));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String className = this.configModularityUtils.convertConfigElementNameToClassName(this.serviceName);
        Class configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
        if (configBeanType == null) {
            String msg = localStrings.getLocalString("delete.module.config.not.such.a.service.found", "Your service name does not match any service installed on this domain.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.configModularityUtils.hasCustomConfig(configBeanType)) {
            List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
            this.deleteDependentConfigElements(defaults);
        } else {
            this.deleteTopLevelExtensionByType(this.config, className, configBeanType);
        }
    }

    private void deleteDependentConfigElements(List<ConfigBeanDefaultValue> defaults) {
        for (ConfigBeanDefaultValue configBeanDefaultValue : defaults) {
            this.deleteDependentConfigElement(configBeanDefaultValue);
        }
    }

    private void deleteDependentConfigElement(final ConfigBeanDefaultValue defaultValue) {
        Class configBeanClass;
        Class parentClass = this.configModularityUtils.getOwningClassForLocation(defaultValue.getLocation());
        final Method m = this.configModularityUtils.findSuitableCollectionGetter(parentClass, configBeanClass = this.configModularityUtils.getClassForFullName(defaultValue.getConfigBeanClassName()));
        if (m != null) {
            try {
                final ConfigBeanProxy parent = this.configModularityUtils.getOwningObject(defaultValue.getLocation());
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

                    public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                        boolean deleted;
                        List col = null;
                        ConfigBeanProxy configBean = null;
                        try {
                            col = (List)m.invoke((Object)param, new Object[0]);
                            if (col != null) {
                                configBean = (ConfigBeanProxy)DeleteModuleConfigCommand.this.configModularityUtils.getCurrentConfigBeanForDefaultValue(defaultValue);
                            }
                        }
                        catch (Exception e) {
                            String message = localStrings.getLocalString("delete.module.config.failed.deleting.dependant", "Failed to remove all configuration elements related to your service form domain.xml. You can use create-module-config --dryRun with your module name to see all relevant configurations and try removing the config elements ");
                            DeleteModuleConfigCommand.this.report.setMessage(message);
                            DeleteModuleConfigCommand.this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                            LOG.log(Level.INFO, "NCLS-CFGAPI-00120", e);
                        }
                        if (configBean != null && !(deleted = DeleteModuleConfigCommand.this.configModularityUtils.deleteConfigurationForConfigBean(configBean, col, defaultValue))) {
                            for (int i = 0; i < col.size(); ++i) {
                                if (!configBeanClass.isAssignableFrom(col.get(i).getClass())) continue;
                                col.remove(col.get(i));
                                DeleteModuleConfigCommand.removeCustomTokens(defaultValue, configBean, parent);
                                return param;
                            }
                        }
                        return param;
                    }
                }, (ConfigBeanProxy)parent);
            }
            catch (Exception e) {
                String message = localStrings.getLocalString("delete.module.config.failed.deleting.dependant", "Failed to remove all configuration elements related to your service form domain.xml. You can use create-module-config --dryRun with your module name to see all relevant configurations and try removing the config elements ");
                this.report.setMessage(message);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                LOG.log(Level.INFO, "NCLS-CFGAPI-00120", e);
            }
        } else {
            this.report.setMessage(localStrings.getLocalString("delete.module.config.failed.deleting.dependant", "Failed to remove all configuration elements related to your service form domain.xml. You can use create-module-config --dryRun with your module name to see all relevant configurations and try removing the config elements "));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void deleteTopLevelExtensionByType(Config config, final String className, Class configBeanType) {
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            if (config.checkIfExtensionExists(configBeanType)) {
                try {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                        public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                            List<ConfigExtension> configExtensions = param.getExtensions();
                            for (ConfigExtension ext : configExtensions) {
                                String configExtensionClass = GlassFishConfigBean.unwrap((ConfigBeanProxy)ext).getProxyType().getSimpleName();
                                if (!configExtensionClass.equals(className)) continue;
                                configExtensions.remove(ext);
                                break;
                            }
                            return configExtensions;
                        }
                    }, (ConfigBeanProxy)config);
                    this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                }
                catch (TransactionFailure e) {
                    String actual = e.getMessage();
                    String msg = localStrings.getLocalString("delete.module.config.failed.to.delete.config", DEFAULT_FORMAT, new Object[]{this.serviceName, actual});
                    this.report.setMessage(msg);
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setFailureCause((Throwable)e);
                }
            } else {
                this.report.setMessage(localStrings.getLocalString("delete.module.config.no.configuration", "No customized configuration exist for this service nor the default configuration has been added to the domain.xml."));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        } else if (DomainExtension.class.isAssignableFrom(configBeanType)) {
            if (this.domain.checkIfExtensionExists(configBeanType)) {
                try {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                        public Object run(Domain param) throws PropertyVetoException, TransactionFailure {
                            List<DomainExtension> domainExtensions = param.getExtensions();
                            for (DomainExtension ext : domainExtensions) {
                                String configExtensionClass = GlassFishConfigBean.unwrap((ConfigBeanProxy)ext).getProxyType().getSimpleName();
                                if (!configExtensionClass.equals(className)) continue;
                                domainExtensions.remove(ext);
                                break;
                            }
                            return domainExtensions;
                        }
                    }, (ConfigBeanProxy)this.domain);
                    this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                }
                catch (TransactionFailure e) {
                    String actual = e.getMessage();
                    String msg = localStrings.getLocalString("delete.module.config.failed.to.delete.config", DEFAULT_FORMAT, new Object[]{this.serviceName, actual});
                    this.report.setMessage(msg);
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setFailureCause((Throwable)e);
                }
            } else {
                this.report.setMessage(localStrings.getLocalString("delete.module.config.no.configuration", "No customized configuration exist for this service nor the default configuration has been added to the domain.xml."));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
    }

    private static <T extends ConfigBeanProxy> boolean removeCustomTokens(ConfigBeanDefaultValue configBeanDefaultValue, T finalConfigBean, ConfigBeanProxy parent) throws TransactionFailure, PropertyVetoException {
        if (parent instanceof SystemPropertyBag) {
            DeleteModuleConfigCommand.removeSystemPropertyForTokens(configBeanDefaultValue.getCustomizationTokens(), (SystemPropertyBag)parent);
            return true;
        }
        Object curParent = finalConfigBean;
        while (!(curParent instanceof SystemPropertyBag)) {
            curParent = curParent.getParent();
        }
        if (!configBeanDefaultValue.getCustomizationTokens().isEmpty()) {
            SystemPropertyBag bag = (SystemPropertyBag)curParent;
            List<ConfigCustomizationToken> tokens = configBeanDefaultValue.getCustomizationTokens();
            DeleteModuleConfigCommand.removeSystemPropertyForTokens(tokens, bag);
            return true;
        }
        return false;
    }

    private static void removeSystemPropertyForTokens(List<ConfigCustomizationToken> tokens, SystemPropertyBag bag) throws TransactionFailure {
        for (ConfigCustomizationToken token : tokens) {
            if (!bag.containsProperty(token.getName())) continue;
            bag.getSystemProperty().remove(bag.getSystemProperty(token.getName()));
        }
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        Class configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
        if (configBeanType == null) {
            return Collections.emptyList();
        }
        if (this.configModularityUtils.hasCustomConfig(configBeanType)) {
            List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
            return this.getAccessChecksForDefaultValue(defaults, this.target, Arrays.asList("read", "delete"));
        }
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType), this.target, Arrays.asList("read", "delete"));
        }
        if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType), this.target, Arrays.asList("read", "delete"));
        }
        return Collections.emptyList();
    }

    public boolean preAuthorization(AdminCommandContext context) {
        return true;
    }
}

