/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.ServletDelegate;
import com.sun.xml.rpc.spi.runtime.ServletSecondDelegate;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Loader;
import org.glassfish.webservices.ServletWebServiceDelegate;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.HttpResponseInfoImpl;
import org.glassfish.webservices.monitoring.ThreadLocalInfo;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.glassfish.webservices.monitoring.WebServiceTesterServlet;

public class JAXRPCServlet
extends HttpServlet {
    private static final long serialVersionUID = 5486495210696942602L;
    private volatile ServletDelegate delegate;
    private volatile ServletWebServiceDelegate myDelegate;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.delegate = JaxRpcObjectFactory.newInstance().createServletDelegate();
            this.myDelegate = new ServletWebServiceDelegate(this.delegate);
            this.delegate.setSecondDelegate((ServletSecondDelegate)this.myDelegate);
            this.delegate.init(servletConfig);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Endpoint endpt;
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && (endpt = wsEngine.getEndpoint(request.getServletPath())) != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
            WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
            return;
        }
        if (this.delegate != null) {
            Endpoint endpt2;
            String messageId = null;
            if (wsEngine.getGlobalMessageListener() != null && (messageId = wsEngine.preProcessRequest(endpt2 = wsEngine.getEndpoint(request.getServletPath()))) != null) {
                ThreadLocalInfo config = new ThreadLocalInfo(messageId, request);
                wsEngine.getThreadLocal().set(config);
            }
            this.delegate.doPost(request, response);
            if (messageId != null) {
                wsEngine.postProcessResponse(messageId, new HttpResponseInfoImpl(response));
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Endpoint endpt;
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && (endpt = WebServiceEngineImpl.getInstance().getEndpoint(request.getServletPath())) != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
            Loader loader = (Loader)endpt.getDescriptor().getBundleDescriptor().getExtraAttribute("WEBLOADER");
            if (loader != null) {
                endpt.getDescriptor().getBundleDescriptor().setClassLoader(loader.getClassLoader());
                endpt.getDescriptor().getBundleDescriptor().removeExtraAttribute("WEBLOADER");
            }
            WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
            return;
        }
        if (this.delegate != null) {
            this.delegate.doGet(request, response);
        }
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
        if (this.myDelegate != null) {
            this.myDelegate.destroy();
        }
    }
}

