/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.gcp;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import fish.payara.microprofile.config.extensions.gcp.GCPSecretsConfigSourceConfiguration;
import fish.payara.microprofile.config.extensions.gcp.model.Secret;
import fish.payara.microprofile.config.extensions.gcp.model.SecretHolder;
import fish.payara.microprofile.config.extensions.gcp.model.SecretsResponse;
import fish.payara.microprofile.config.extensions.oauth.OAuth2Client;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.stream.JsonParser;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Service;

@Service(name="gcp-secrets-config-source")
public class GCPSecretsConfigSource
extends ConfiguredExtensionConfigSource<GCPSecretsConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(GCPSecretsConfigSource.class.getName());
    private static final String AUTH_URL = "https://www.googleapis.com/oauth2/v4/token";
    private static final String LIST_SECRETS_ENDPOINT = "https://secretmanager.googleapis.com/v1/projects/%s/secrets";
    private static final String SECRET_ENDPOINT = "https://secretmanager.googleapis.com/v1/projects/%s/secrets/%s";
    private static final String GET_SECRETS_VERSION_ENDPOINT = "https://secretmanager.googleapis.com/v1/projects/%s/secrets/%s/versions/latest:access";
    private static final String CREATE_SECRET_VERSION_ENDPOINT = "https://secretmanager.googleapis.com/v1/projects/%s/secrets/%s:addVersion";
    private Client client = ClientBuilder.newClient();
    private OAuth2Client authClient;
    @Inject
    private ServerEnvironment env;
    @Inject
    MicroprofileConfigConfiguration mpconfig;

    public void bootstrap() {
        String privateKey;
        String clientEmail;
        block28: {
            clientEmail = null;
            privateKey = null;
            try {
                File tokenFile = this.getTokenFile();
                if (tokenFile == null) {
                    LOGGER.warning("Couldn't find token file, make sure it's configured.");
                    break block28;
                }
                try (JsonParser parser = Json.createParser((InputStream)new FileInputStream(this.getTokenFile()));){
                    while (parser.hasNext()) {
                        JsonParser.Event parseEvent = parser.next();
                        if (parseEvent != JsonParser.Event.KEY_NAME) continue;
                        String keyName = parser.getString();
                        parser.next();
                        switch (keyName) {
                            case "client_email": {
                                clientEmail = parser.getString();
                                break;
                            }
                            case "private_key": {
                                privateKey = parser.getString();
                            }
                        }
                        if (clientEmail == null || privateKey == null) continue;
                        break;
                    }
                    if (clientEmail == null || privateKey == null) {
                        throw new PropertyVetoException("Error reading JSON key file", new PropertyChangeEvent(this.configuration, "jsonKeyFile", null, null));
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Couldn't find or read the GCP key file, make sure it exists.", ex);
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        if (clientEmail != null && privateKey != null) {
            try {
                SignedJWT jwt = GCPSecretsConfigSource.buildJwt(clientEmail, "https://www.googleapis.com/auth/cloud-platform");
                jwt.sign((JWSSigner)new RSASSASigner(GCPSecretsConfigSource.parsePrivateKey(privateKey)));
                data.put("assertion", jwt.serialize());
            }
            catch (JOSEException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOGGER.log(Level.WARNING, "An error occurred while signing the GCP auth token", e);
            }
        }
        this.authClient = new OAuth2Client(AUTH_URL, data);
    }

    private String authenticate() {
        Response response = this.authClient.authenticate();
        int status = response.getStatus();
        if (status == 200) {
            JsonObject data = (JsonObject)response.readEntity(JsonObject.class);
            Integer expirySeconds = data.getInt("expires_in");
            this.authClient.expire(Duration.ofSeconds(expirySeconds.intValue()));
            return data.getString("access_token");
        }
        if (status == 400) {
            LOGGER.log(Level.WARNING, "Couldn't authenticate with GCP. Check your configuration options are correct.");
        }
        return null;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> results = new HashMap<String, String>();
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return results;
        }
        WebTarget secretsTarget = this.client.target(String.format(LIST_SECRETS_ENDPOINT, ((GCPSecretsConfigSourceConfiguration)this.configuration).getProjectName()));
        Response secretsResponse = secretsTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
        if (secretsResponse.getStatus() != 200) {
            return results;
        }
        List<Secret> secrets = ((SecretsResponse)secretsResponse.readEntity(SecretsResponse.class)).getSecrets();
        for (Secret secret : secrets) {
            String secretName = secret.getName();
            results.put(secretName, this.getValue(secretName));
        }
        return results;
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public String getValue(String propertyName) {
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return null;
        }
        WebTarget secretTarget = this.client.target(String.format(GET_SECRETS_VERSION_ENDPOINT, ((GCPSecretsConfigSourceConfiguration)this.configuration).getProjectName(), propertyName));
        Response secretResponse = secretTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
        int status = secretResponse.getStatus();
        if (status != 200) {
            if (status != 400) {
                LOGGER.log(Level.WARNING, "Failed to get GCP secret. {0}", secretResponse.readEntity(String.class));
            }
            return null;
        }
        String value = ((SecretHolder)secretResponse.readEntity(SecretHolder.class)).getPayload().getData();
        return value;
    }

    public boolean setValue(String name, String value) {
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return false;
        }
        WebTarget secretTarget = this.client.target(String.format(LIST_SECRETS_ENDPOINT, ((GCPSecretsConfigSourceConfiguration)this.configuration).getProjectName()));
        Response secretResponse = secretTarget.queryParam("secretId", new Object[]{name}).request().accept(new String[]{"application/json"}).header("Content-Type", (Object)"application/json").header("Authorization", (Object)("Bearer " + accessToken)).post(Entity.entity((Object)new Secret(), (String)"application/json"));
        int status = secretResponse.getStatus();
        if (status != 200 && status != 409) {
            LOGGER.log(Level.WARNING, "Failed to set GCP secret. {0}", secretResponse.readEntity(String.class));
            return false;
        }
        WebTarget addSecretTarget = this.client.target(String.format(CREATE_SECRET_VERSION_ENDPOINT, ((GCPSecretsConfigSourceConfiguration)this.configuration).getProjectName(), name));
        Response addSecretResponse = addSecretTarget.request().accept(new String[]{"application/json"}).header("Content-Type", (Object)"application/json").header("Authorization", (Object)("Bearer " + accessToken)).post(Entity.entity((Object)new SecretHolder(value), (String)"application/json"));
        if (addSecretResponse.getStatus() == 200) {
            return true;
        }
        LOGGER.log(Level.WARNING, "Failed to set GCP secret. {0}", addSecretResponse.readEntity(String.class));
        return false;
    }

    public boolean deleteValue(String name) {
        String accessToken = this.authenticate();
        if (accessToken == null) {
            return false;
        }
        WebTarget secretTarget = this.client.target(String.format(SECRET_ENDPOINT, ((GCPSecretsConfigSourceConfiguration)this.configuration).getProjectName(), name));
        Response secretResponse = secretTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).delete();
        if (secretResponse.getStatus() == 200) {
            return true;
        }
        LOGGER.log(Level.WARNING, "Failed to delete GCP secret. {0}", secretResponse.readEntity(String.class));
        return false;
    }

    public String getSource() {
        return "cloud";
    }

    public String getName() {
        return "gcp";
    }

    public int getOrdinal() {
        return Integer.parseInt(this.mpconfig.getCloudOrdinality());
    }

    private static SignedJWT buildJwt(String issuer, String scope) {
        Instant now = Instant.now();
        Instant expiry = now.plus(1L, ChronoUnit.MINUTES);
        JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer(issuer).audience(AUTH_URL).issueTime(Date.from(now)).expirationTime(Date.from(expiry)).claim("scope", (Object)scope).build();
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).build();
        return new SignedJWT(header, claims);
    }

    private static PrivateKey parsePrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String privateKeyContent = privateKey.replaceAll("\\n", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(new Base64(privateKeyContent).decode());
        return kf.generatePrivate(keySpecPKCS8);
    }

    private File getTokenFile() {
        String fileName = ((GCPSecretsConfigSourceConfiguration)this.configuration).getTokenFilePath();
        if (fileName != null) {
            return this.env.getConfigDirPath().toPath().resolve(((GCPSecretsConfigSourceConfiguration)this.configuration).getTokenFilePath()).toFile();
        }
        return null;
    }
}

