/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.glassfish.api.admin.progress.ProgressStatusDTO;

public class ProgressStatusDTOJsonProprietaryReader
implements ProprietaryReader<ProgressStatusDTO> {
    private static final JsonFactory factory = new JsonFactory();

    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(ProgressStatusDTO.class);
    }

    public ProgressStatusDTO readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    @Override
    public ProgressStatusDTO readFrom(InputStream is, String contentType) throws IOException {
        try (JsonParser jp = factory.createJsonParser(is);){
            JsonToken token = jp.nextToken();
            jp.nextToken();
            JsonToken token2 = jp.nextToken();
            if (token != JsonToken.START_OBJECT || token2 != JsonToken.START_OBJECT || !"progress-status".equals(jp.getCurrentName())) {
                throw new IOException("Not expected type (progress-status) but (" + jp.getCurrentName() + ")");
            }
            ProgressStatusDTO progressStatusDTO = ProgressStatusDTOJsonProprietaryReader.readProgressStatus(jp);
            return progressStatusDTO;
        }
    }

    public static ProgressStatusDTO readProgressStatus(JsonParser jp) throws IOException {
        ProgressStatusDTO.ChildProgressStatusDTO child = ProgressStatusDTOJsonProprietaryReader.readChildProgressStatus(jp);
        return child.getProgressStatus();
    }

    public static ProgressStatusDTO.ChildProgressStatusDTO readChildProgressStatus(JsonParser jp) throws IOException {
        ProgressStatusDTO psd = new ProgressStatusDTO();
        int allocatedSteps = 0;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("name".equals(fieldname)) {
                psd.setName(jp.getText());
                continue;
            }
            if ("id".equals(fieldname)) {
                psd.setId(jp.getText());
                continue;
            }
            if ("total-step-count".equals(fieldname)) {
                psd.setTotalStepCount(jp.getIntValue());
                continue;
            }
            if ("current-step-count".equals(fieldname)) {
                psd.setCurrentStepCount(jp.getIntValue());
                continue;
            }
            if ("complete".equals(fieldname)) {
                psd.setCompleted(jp.getBooleanValue());
                continue;
            }
            if ("allocated-steps".equals(fieldname)) {
                allocatedSteps = jp.getIntValue();
                continue;
            }
            if (!"children".equals(fieldname)) continue;
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                if (jp.getCurrentToken() != JsonToken.START_OBJECT) continue;
                ProgressStatusDTO.ChildProgressStatusDTO child = ProgressStatusDTOJsonProprietaryReader.readChildProgressStatus(jp);
                psd.getChildren().add(child);
            }
        }
        return new ProgressStatusDTO.ChildProgressStatusDTO(allocatedSteps, psd);
    }
}

