/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.microprofile.SetSecureMicroprofileConfigurationCommand;
import fish.payara.microprofile.healthcheck.config.MicroprofileHealthCheckConfiguration;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@Service(name="set-microprofile-healthcheck-configuration")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set-microprofile-healthcheck-configuration")
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileHealthCheckConfiguration.class, opType=RestEndpoint.OpType.POST, description="Configures Microprofile HealthCheck")})
public class SetMPHealthCheckConfiguration
extends SetSecureMicroprofileConfigurationCommand {
    private static final Logger LOGGER = Logger.getLogger("MP-HealthCheck");
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="endpoint", optional=true)
    private String endpoint;
    @Param(name="virtualServers", optional=true)
    private String virtualServers;
    @Inject
    ServiceLocator habitat;
    @Inject
    private Target targetUtil;
    @Inject
    UnprocessedConfigListener unprocessedListener;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Subject subject = context.getSubject();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        MicroprofileHealthCheckConfiguration config = (MicroprofileHealthCheckConfiguration)targetConfig.getExtensionByType(MicroprofileHealthCheckConfiguration.class);
        if (Boolean.TRUE.equals(this.securityEnabled) || Boolean.parseBoolean(config.getSecurityEnabled())) {
            ActionReport checkUserReport = actionReport.addSubActionsReport();
            ActionReport createUserReport = actionReport.addSubActionsReport();
            if (!this.defaultMicroprofileUserExists(checkUserReport, subject) && !checkUserReport.hasFailures()) {
                this.createDefaultMicroprofileUser(createUserReport, subject);
            }
            if (checkUserReport.hasFailures() || createUserReport.hasFailures()) {
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.enabled != null) {
                    configProxy.setEnabled(this.enabled.toString());
                }
                if (this.endpoint != null) {
                    configProxy.setEndpoint(this.endpoint);
                }
                if (this.virtualServers != null) {
                    configProxy.setVirtualServers(this.virtualServers);
                }
                if (this.securityEnabled != null) {
                    configProxy.setSecurityEnabled(this.securityEnabled.toString());
                }
                if (this.roles != null) {
                    configProxy.setRoles(this.roles);
                }
                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return configProxy;
            }, (ConfigBeanProxy)config);
            actionReport.setMessage("Restart server for change to take effect");
        }
        catch (TransactionFailure ex) {
            actionReport.failure(LOGGER, "Failed to update HealthCheck configuration", (Throwable)ex);
        }
        if (!actionReport.hasFailures() && !actionReport.hasWarnings()) {
            actionReport.getSubActionsReport().clear();
        }
    }
}

