/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import fish.payara.microprofile.jwtauth.eesecurity.CacheableString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.eclipse.microprofile.config.Config;

public class JwtKeyStoreUtils {
    private static final Logger LOGGER = Logger.getLogger(JwtKeyStoreUtils.class.getName());

    static String trimPem(String key) {
        return key.replaceAll("-----BEGIN (.*)-----", "").replaceAll("-----END (.*)----", "").replaceAll("\r\n", "").replaceAll("\n", "").trim();
    }

    static CacheableString readMPKeyFromLocation(Config config, String mpConfigProperty, Duration defaultCacheTTL) {
        Optional locationOpt = config.getOptionalValue(mpConfigProperty, String.class);
        if (!locationOpt.isPresent()) {
            return CacheableString.empty(defaultCacheTTL);
        }
        String publicKeyLocation = (String)locationOpt.get();
        return JwtKeyStoreUtils.readKeyFromLocation(publicKeyLocation, defaultCacheTTL);
    }

    static CacheableString readKeyFromLocation(String keyLocation, Duration defaultCacheTTL) {
        URL keyURL = Thread.currentThread().getContextClassLoader().getResource(keyLocation);
        if (keyURL == null) {
            try {
                keyURL = new URL(keyLocation);
            }
            catch (MalformedURLException ex) {
                keyURL = null;
            }
        }
        if (keyURL == null) {
            return CacheableString.empty(defaultCacheTTL);
        }
        try {
            return JwtKeyStoreUtils.readKeyFromURL(keyURL, defaultCacheTTL);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read key.", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private static CacheableString readKeyFromURL(URL keyURL, Duration defaultCacheTTL) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static JsonObject parseJwks(String jwksValue) throws Exception {
        JsonObject jwks;
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jwksValue));){
            jwks = reader.readObject();
        }
        catch (Exception ex) {
            byte[] jwksDecodedValue = Base64.getDecoder().decode(jwksValue);
            try (ByteArrayInputStream jwksStream = new ByteArrayInputStream(jwksDecodedValue);
                 JsonReader reader2 = Json.createReader((InputStream)jwksStream);){
                jwks = reader2.readObject();
            }
        }
        return jwks;
    }

    static JsonObject findJwk(JsonArray keys, String keyID) {
        if (Objects.isNull(keyID) && keys.size() > 0) {
            return keys.getJsonObject(0);
        }
        for (JsonValue value : keys) {
            JsonObject jwk = value.asJsonObject();
            if (!Objects.equals(keyID, jwk.getString("kid"))) continue;
            return jwk;
        }
        throw new IllegalStateException("No matching JWK for KeyID.");
    }

    private static /* synthetic */ Duration lambda$readKeyFromURL$4(String maxAgeDirective) {
        String[] keyValue = maxAgeDirective.split("=", 2);
        String maxAge = keyValue[keyValue.length - 1];
        try {
            return Duration.ofSeconds(Long.parseLong(maxAge));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static /* synthetic */ boolean lambda$readKeyFromURL$3(String directive) {
        return directive.trim().startsWith("max-age");
    }

    private static /* synthetic */ Stream lambda$readKeyFromURL$2(String headerValue) {
        return Stream.of(headerValue.split(","));
    }

    private static /* synthetic */ Stream lambda$readKeyFromURL$1(Map.Entry headers) {
        return ((List)headers.getValue()).stream();
    }

    private static /* synthetic */ boolean lambda$readKeyFromURL$0(Map.Entry e) {
        return e.getKey() != null && ((String)e.getKey()).trim().equalsIgnoreCase("Cache-Control");
    }
}

