/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.handlers;

import com.sun.messaging.bridge.admin.BridgeServiceManagerImpl;
import com.sun.messaging.bridge.admin.handlers.AdminCmdHandler;
import com.sun.messaging.bridge.admin.handlers.AdminMessageHandler;
import com.sun.messaging.bridge.admin.resources.BridgeManagerResources;
import com.sun.messaging.bridge.admin.util.AdminMessageType;
import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.api.BridgeException;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class ListHandler
extends AdminCmdHandler {
    public ListHandler(AdminMessageHandler parent, BridgeServiceManagerImpl bsm) {
        super(parent, bsm);
    }

    @Override
    public void handle(Session session, ObjectMessage msg, ObjectMessage reply, BridgeManagerResources bmr) throws BridgeException, JMSException, Exception {
        int msgtype = msg.getIntProperty("JMQMessageType");
        if (msgtype != 18) {
            throw new BridgeException(this._bmr.getKString("BB4013", AdminMessageType.getString(msgtype)));
        }
        String bnameval = msg.getStringProperty("JMQBridgeName");
        String btypeval = msg.getStringProperty("JMQBridgeType");
        String lnameval = msg.getStringProperty("JMQLinkName");
        boolean debugMode = msg.getBooleanProperty("JMQDebug");
        String bname = bnameval == null ? null : bnameval.trim();
        String btype = btypeval == null ? null : btypeval.trim().toUpperCase();
        String lname = lnameval == null ? null : lnameval.trim();
        String[] args = null;
        if (bname != null && lname != null) {
            if (bname.length() == 0) {
                throw new BridgeException(this._bmr.getKString("BB3009", bname));
            }
            if (lname.trim().length() == 0) {
                throw new BridgeException(this._bmr.getKString("BB3010", lname));
            }
            args = debugMode ? new String[]{"-ln", lname, "-debug"} : new String[]{"-ln", lname};
            ArrayList<BridgeCmdSharedReplyData> data = this._bsm.listBridge(bname, args, btype, bmr);
            reply.setObject(data);
            this.parent.sendReply(session, (Message)msg, reply, 200, null, bmr);
            return;
        }
        if (lname != null && bname == null) {
            throw new BridgeException(this._bmr.getKString("BB3011"));
        }
        if (bname != null && bname.length() == 0) {
            throw new BridgeException(this._bmr.getKString("BB3009", bname));
        }
        args = debugMode ? new String[]{"-debug"} : null;
        ArrayList<BridgeCmdSharedReplyData> data = this._bsm.listBridge(bname, args, btype, bmr);
        reply.setObject(data);
        this.parent.sendReply(session, (Message)msg, reply, 200, null, bmr);
    }
}

