/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.api.JwtClaims;
import fish.payara.security.openid.domain.NimbusJwtClaims;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class IdentityTokenImpl
implements IdentityToken {
    private final String token;
    private final long tokenMinValidity;
    private final JWT tokenJWT;
    private JWTClaimsSet claims;

    public IdentityTokenImpl(String token, long tokenMinValidity) {
        this.token = token;
        this.tokenMinValidity = tokenMinValidity;
        try {
            this.tokenJWT = JWTParser.parse(token);
            this.claims = this.tokenJWT.getJWTClaimsSet();
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Error in parsing the Token", ex);
        }
    }

    private IdentityTokenImpl(JWT token, JWTClaimsSet verifiedClaims, long tokenMinValidity) {
        this.token = token.getParsedString();
        this.tokenJWT = token;
        this.claims = verifiedClaims;
        this.tokenMinValidity = tokenMinValidity;
    }

    public JWT getTokenJWT() {
        return this.tokenJWT;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public Map<String, Object> getClaims() {
        if (this.claims == null) {
            return Collections.emptyMap();
        }
        return this.claims.getClaims();
    }

    @Override
    public JwtClaims getJwtClaims() {
        return NimbusJwtClaims.ifPresent(this.claims);
    }

    @Override
    public Object getClaim(String key) {
        return this.getClaims().get(key);
    }

    public boolean isEncrypted() {
        return this.tokenJWT != null && this.tokenJWT instanceof EncryptedJWT;
    }

    public boolean isSigned() {
        return this.tokenJWT != null && this.tokenJWT instanceof EncryptedJWT;
    }

    @Override
    public boolean isExpired() {
        boolean expired = true;
        Date exp = (Date)this.getClaim("exp");
        if (!Objects.nonNull(exp)) {
            throw new IllegalStateException("Missing expiration time (exp) claim in identity token");
        }
        expired = System.currentTimeMillis() + this.tokenMinValidity > exp.getTime();
        return expired;
    }

    public String toString() {
        return this.token;
    }

    public IdentityToken withClaims(JWTClaimsSet verifiedClaims) {
        return new IdentityTokenImpl(this.tokenJWT, verifiedClaims, this.tokenMinValidity);
    }
}

