/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.annotations;

import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdProviderMetadata;
import fish.payara.security.openid.api.DisplayType;
import fish.payara.security.openid.api.PromptType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface OpenIdAuthenticationDefinition {
    public static final String OPENID_MP_PROVIDER_URI = "payara.security.openid.providerURI";
    public static final String OPENID_MP_CLIENT_ID = "payara.security.openid.clientId";
    public static final String OPENID_MP_CLIENT_SECRET = "payara.security.openid.clientSecret";
    public static final String OPENID_MP_REDIRECT_URI = "payara.security.openid.redirectURI";
    public static final String OPENID_MP_SCOPE = "payara.security.openid.scope";
    public static final String OPENID_MP_RESPONSE_TYPE = "payara.security.openid.responseType";
    public static final String OPENID_MP_RESPONSE_MODE = "payara.security.openid.responseMode";
    public static final String OPENID_MP_PROMPT = "payara.security.openid.prompt";
    public static final String OPENID_MP_DISPLAY = "payara.security.openid.display";
    public static final String OPENID_MP_USE_NONCE = "payara.security.openid.useNonce";
    public static final String OPENID_MP_USE_SESSION = "payara.security.openid.useSession";
    public static final String OPENID_MP_JWKS_CONNECT_TIMEOUT = "payara.security.openid.jwks.connect.timeout";
    public static final String OPENID_MP_JWKS_READ_TIMEOUT = "payara.security.openid.jwks.read.timeout";
    public static final String OPENID_MP_CLIENT_ENC_ALGORITHM = "payara.security.openid.client.encryption.algorithm";
    public static final String OPENID_MP_CLIENT_ENC_METHOD = "payara.security.openid.client.encryption.method";
    public static final String OPENID_MP_CLIENT_ENC_JWKS = "payara.security.openid.client.encryption.jwks";
    public static final String OPENID_MP_TOKEN_AUTO_REFRESH = "payara.security.openid.token.autoRefresh";
    public static final String OPENID_MP_TOKEN_MIN_VALIDITY = "payara.security.openid.token.minValidity";
    public static final String OPENID_MP_SESSION_SCOPED_CONFIGURATION = "payara.security.openid.sessionScopedConfiguration";

    public String providerURI() default "";

    public OpenIdProviderMetadata providerMetadata() default @OpenIdProviderMetadata;

    public ClaimsDefinition claimsDefinition() default @ClaimsDefinition;

    public LogoutDefinition logout() default @LogoutDefinition;

    public String clientId() default "";

    public String clientSecret() default "";

    public String redirectURI() default "${baseURL}/Callback";

    public String[] scope() default {"openid", "email", "profile"};

    public String responseType() default "code";

    public String responseMode() default "";

    public PromptType[] prompt() default {};

    public DisplayType display() default DisplayType.PAGE;

    public boolean useNonce() default true;

    public boolean useSession() default true;

    public String[] extraParameters() default {};

    public int jwksConnectTimeout() default 500;

    public int jwksReadTimeout() default 500;

    public boolean tokenAutoRefresh() default false;

    public int tokenMinValidity() default 10000;
}

