/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
import com.sun.enterprise.admin.servermgmt.StringValidator;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayInputStream;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.InputSource;

public class RepositoryNameValidator
extends StringValidator {
    private static final String VALID_CHAR = "[^\\,\\/ \\&\\;\\`\\'\\\\\"\\|\\*\\!\\?\\~\\<\\>\\^\\(\\)\\[\\]\\{\\}\\$\\:\\%]*";
    private static final String IAS_NAME = "com.sun.appserv:name=";
    private static final String XML_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <xml>";
    private static final String XML_2 = "</xml>";
    private static final StringManager STRING_MANAGER = StringManager.getManager(RepositoryNameValidator.class);

    public RepositoryNameValidator(String name) {
        super(name);
    }

    @Override
    public void validate(Object str) throws InvalidConfigException {
        super.validate(str);
        this.checkValidName((String)str);
        this.checkValidXmlToken((String)str);
        this.checkValidObjectNameToken((String)str);
    }

    public void checkValidName(String name) throws InvalidConfigException {
        if (!name.matches(VALID_CHAR)) {
            throw new InvalidConfigException(STRING_MANAGER.getString("validator.invalid_value", (Object)this.getName(), (Object)name));
        }
    }

    public void checkValidXmlToken(String name) throws InvalidConfigException {
        try {
            String xml = XML_1 + name + XML_2;
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            InputSource is = new InputSource(bais);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.parse(is);
        }
        catch (Exception e) {
            throw new InvalidConfigException(STRING_MANAGER.getString("validator.invalid_value", (Object)this.getName(), (Object)name));
        }
    }

    public void checkValidObjectNameToken(String name) throws InvalidConfigException {
        try {
            new ObjectName(IAS_NAME + name);
        }
        catch (Exception e) {
            throw new InvalidConfigException(STRING_MANAGER.getString("validator.invalid_value", (Object)this.getName(), (Object)name));
        }
    }
}

