/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.glassfish.appclient.client.AppClientFacade;
import org.glassfish.appclient.client.ExitManager;
import org.glassfish.appclient.client.JWSACCMaskingClassLoader;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.jws.boot.ErrorDisplayDialog;
import org.glassfish.appclient.client.jws.boot.LaunchSecurityHelper;

public class JWSAppClientContainerMain {
    public static final String SECURITY_CONFIG_PATH_PLACEHOLDER = "security.config.path";
    private static final Logger logger = Logger.getLogger(JWSAppClientContainerMain.class.getName());
    private static final String ENDORSED_PACKAGE_PROPERTY_NAME = "endorsed-standard-packages";
    private static final ResourceBundle rb = ResourceBundle.getBundle(JWSAppClientContainerMain.class.getPackage().getName().replaceAll("\\.", "/") + ".LocalStrings");
    private static final Map<JWSACCSetting, String> jwsaccSettings = new EnumMap<JWSACCSetting, String>(JWSACCSetting.class);
    private static final String JWSACC_PROPERTY_NAME_PREFIX = "javaws.acc.";
    private static final String JWSACC_EXIT_AFTER_RETURN = "exitAfterReturn";
    private static final String JWSACC_FORCE_ERROR = "forceError";
    private static final String JWSACC_RUN_ON_SWING_THREAD = "runOnSwingThread";
    private static final String JWSACC_TEST_OUTPUT = "testOutput";
    private static ExitManager exitManager = null;
    private static long now;

    private static boolean isTestMode() {
        return exitManager != null;
    }

    public static void main(String[] args) {
        try {
            now = System.currentTimeMillis();
            JWSAppClientContainerMain.processJWSArgs();
            String agentArgsText = System.getProperty("agent.args");
            LaunchSecurityHelper.setPermissions();
            JWSAppClientContainerMain.insertMaskingLoader();
            ClientRunner runner = new ClientRunner(agentArgsText, args);
            if (JWSAppClientContainerMain.runOnSwingThread()) {
                SwingUtilities.invokeAndWait(runner);
            } else {
                runner.run();
            }
        }
        catch (Throwable thr) {
            if (JWSAppClientContainerMain.isTestMode()) {
                exitManager.recordFailure(thr);
            }
            throw new RuntimeException(rb.getString("jwsacc.errorLaunch"), thr);
        }
    }

    private static void insertMaskingLoader() throws IOException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String loaderConfig = System.getProperty("loader.config");
        StringReader sr = new StringReader(loaderConfig);
        Properties props = new Properties();
        props.load(sr);
        ClassLoader jwsLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader mcl = JWSAppClientContainerMain.getMaskingClassLoader(jwsLoader.getParent(), props);
        Field jwsLoaderParentField = ClassLoader.class.getDeclaredField("parent");
        jwsLoaderParentField.setAccessible(true);
        jwsLoaderParentField.set(jwsLoader, mcl);
    }

    private static ClassLoader getMaskingClassLoader(ClassLoader parent, Properties props) {
        Collection<String> endorsedPackagesToMask = JWSAppClientContainerMain.prepareEndorsedPackages(props.getProperty(ENDORSED_PACKAGE_PROPERTY_NAME));
        return new JWSACCMaskingClassLoader(parent, endorsedPackagesToMask);
    }

    private static Collection<String> prepareEndorsedPackages(String packageNames) {
        HashSet<String> result = new HashSet<String>();
        for (String s : packageNames.split(",")) {
            if ((s = s.trim()).length() <= 0) continue;
            result.add(s);
        }
        return result;
    }

    private static void processJWSArgs() {
        String propValue;
        int i = 0;
        while ((propValue = System.getProperty(JWSACC_PROPERTY_NAME_PREFIX + i)) != null) {
            int equals = propValue.indexOf(61);
            JWSACCSetting setting = JWSACCSetting.find(equals == -1 ? propValue : propValue.substring(0, equals));
            if (setting != null) {
                String settingValue = equals == -1 ? "" : propValue.substring(equals + 1);
                jwsaccSettings.put(setting, settingValue);
                setting.run(settingValue);
            }
            ++i;
        }
    }

    private static boolean runOnSwingThread() {
        return jwsaccSettings.containsKey((Object)JWSACCSetting.RUN_ON_SWING_THREAD);
    }

    private static void prepareTestMode(String testReportLocation) {
        exitManager = new ExitManager(testReportLocation);
        try {
            SplitPrintStream splitPS = new SplitPrintStream(System.out, new File(testReportLocation));
            System.setOut(splitPS);
            logger.log(Level.FINE, "Also sending output to {0}", testReportLocation);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class SplitPrintStream
    extends PrintStream {
        private final PrintStream originalPS;

        public SplitPrintStream(PrintStream originalPS, File newOutputFile) throws FileNotFoundException {
            super(newOutputFile);
            this.originalPS = originalPS;
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
            this.originalPS.write(b);
        }

        @Override
        public void write(int b) {
            super.write(b);
            this.originalPS.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            this.originalPS.write(buf, off, len);
        }
    }

    private static enum JWSACCSetting {
        EXIT_AFTER_RETURN("exitAfterReturn"),
        FORCE_ERROR("forceError"),
        RUN_ON_SWING_THREAD("runOnSwingThread"),
        TEST_OUTPUT("testOutput", new Runner(){

            @Override
            public void run(String testOutputFile) {
                JWSAppClientContainerMain.prepareTestMode(testOutputFile);
            }
        });

        private final String propertyNameSuffix;
        private final Runner action;

        private JWSACCSetting(String propertyNameSuffix) {
            this(propertyNameSuffix, new Runner());
        }

        private JWSACCSetting(String propertyNameSuffix, Runner action) {
            this.propertyNameSuffix = propertyNameSuffix;
            this.action = action;
        }

        private void run(String runInfo) {
            if (this.action != null) {
                this.action.run(runInfo);
            }
        }

        private static JWSACCSetting find(String targetSuffix) {
            for (JWSACCSetting candidate : JWSACCSetting.values()) {
                if (!candidate.propertyNameSuffix.equals(targetSuffix)) continue;
                return candidate;
            }
            return null;
        }

        private static class Runner {
            private Runner() {
            }

            protected void run(String info) {
            }
        }
    }

    private static class ClientRunner
    implements Runnable {
        private final String agentArgsText;
        private final String[] args;

        private ClientRunner(String agentArgsText, String[] args) {
            this.agentArgsText = agentArgsText;
            this.args = args;
        }

        @Override
        public void run() {
            try {
                AppClientFacade.prepareACC(this.agentArgsText, null);
                AppClientFacade.launch(this.args);
                logger.log(Level.FINE, "JWSAppClientContainer finished after {0} ms", System.currentTimeMillis() - now);
            }
            catch (UserError ue) {
                if (!JWSAppClientContainerMain.isTestMode()) {
                    ErrorDisplayDialog.showUserError(ue, rb);
                }
                throw new RuntimeException(ue);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }
    }
}

