/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class MaskingClassLoader
extends ClassLoader {
    private final Set<String> punchins = new HashSet<String>();
    private final String[] multiples;
    private final boolean useExplicitCallsToFindSystemClass;

    public MaskingClassLoader(ClassLoader parent, Collection<String> punchins, Collection<String> multiples) {
        this(parent, punchins, multiples, true);
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> punchins, Collection<String> multiples, boolean useExplicitCallsToFindSystemClass) {
        super(parent);
        this.punchins.addAll(punchins);
        this.multiples = multiples.toArray(new String[multiples.size()]);
        this.useExplicitCallsToFindSystemClass = useExplicitCallsToFindSystemClass;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            if (this.useExplicitCallsToFindSystemClass) {
                return this.findSystemClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.isDottedNameLoadableByParent(name)) {
            return super.loadClass(name, resolve);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        if (this.isDottedNameLoadableByParent(this.resourceToDotted(name))) {
            return super.getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isDottedNameLoadableByParent(this.resourceToDotted(name))) {
            return super.getResources(name);
        }
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    private String resourceToDotted(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name.replace("/", ".");
    }

    protected boolean isDottedNameLoadableByParent(String name) {
        if (!name.startsWith("javax.") && !name.startsWith("org.")) {
            return true;
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        if (this.punchins.contains(packageName)) {
            return true;
        }
        for (String multiple : this.multiples) {
            if (!name.startsWith(multiple)) continue;
            return true;
        }
        return false;
    }
}

